<?php
// includes/header.php
// Iniciar sesión aquí también es buena idea por si se incluye en páginas que aún no la iniciaron
if (session_status() === PHP_SESSION_NONE) {
    session_start(); // Opciones de cookie ya aplicadas en auth_check si se incluyó antes
}

// Datos para el encabezado (puedes moverlos a un archivo de config si prefieres)
$company_name = "Anfitriones A.P.R.";
$logo_path = "/recibos_php/public/images/anfi.png"; // Usa ruta absoluta desde la raíz web

// Determinar el nombre a mostrar (si está logueado)
$display_name_header = $_SESSION['full_name'] ?? $_SESSION['username'] ?? null;

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/recibos_php/public/css/estilos.css">
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) : 'Nom-Online'; ?> - <?php echo htmlspecialchars($company_name); ?></title>
</head>
<body>
    <header class="main-header">
        <div class="logo">
            <img src="<?php echo $logo_path; ?>" alt="Logo <?php echo htmlspecialchars($company_name); ?>">
        </div>
        <div class="company-title">
            <?php echo htmlspecialchars($company_name); ?>
        </div>
        <?php // Mostrar bienvenida y logout solo si está logueado ?>
        <?php if ($display_name_header): ?>
            <div class="user-welcome">
                 <span>Bienvenido, <?php echo htmlspecialchars($display_name_header); ?>!</span>
                 <a href="/recibos_php/logout.php">Cerrar Sesión</a>
                 <?php // Enlace opcional al panel de admin si es admin ?>
                 <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true): ?>
                     | <a href="/recibos_php/admin/users_list.php">Admin Usuarios</a>
                 <?php endif; ?>
            </div>
        <?php endif; ?>
    </header>

    <main class="container"> <?php // El contenido específico de cada página irá aquí ?>