<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        // Opciones de seguridad para cookies de sesión (recomendado)
        'cookie_lifetime' => 0, // Expira al cerrar navegador (si no hay timeout)
        'cookie_httponly' => true, // No accesible por JavaScript
        'cookie_secure' => isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on', // Solo HTTPS en producción
        'cookie_samesite' => 'Lax' // Protección CSRF básica
    ]);
}

// --- AÑADIR ESTAS LÍNEAS ---
// Instruir al navegador y proxies a NO almacenar en caché esta página.
// Es crucial para evitar que el botón "Atrás" muestre contenido antiguo después de cerrar sesión.
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0'); // HTTP 1.1+
header('Pragma: no-cache'); // HTTP 1.0 (para compatibilidad)
header('Expires: Sat, 01 Jan 2000 00:00:00 GMT'); // Fecha en el pasado
// --- FIN DE LÍNEAS AÑADIDAS ---

// Timeout de sesión (Opcional, ejemplo 30 minutos)
$timeout_duration = 1800; // 30 minutos en segundos
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity']) > $timeout_duration) {
    session_unset();
    session_destroy();
    header("Location: /recibos_php/login.php?error=session_expired");
    exit;
}

// Actualizar última actividad SOLO si la sesión es válida y no expiró justo ahora
if (isset($_SESSION['user_id'])) {
    $_SESSION['last_activity'] = time();
}

// Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    header("Location: /recibos_php/login.php?error=auth_required");
    exit;
}
?>