<?php
require_once('includes/auth_check.php'); // Necesita estar logueado

$employee_id = $_SESSION['employee_id'] ?? null;
// $is_admin = $_SESSION['is_admin'] ?? false; // Descomentar si admins pueden descargar todo

// Solo usuarios regulares con ID pueden descargar (o admins si se habilita)
if (!$employee_id /* && !$is_admin */ ) {
    header('HTTP/1.0 403 Forbidden');
    exit("Acceso denegado.");
}

// 1. Validar Filename (Básico)
$filename = $_GET['filename'] ?? '';
if (strpos($filename, '/') !== false || strpos($filename, '\\') !== false || strpos($filename, '..') !== false) {
    // Si se encuentra alguno de los peligrosos...
    header('HTTP/1.0 400 Bad Request');
    // Cambié un poco el mensaje para saber que se ejecutó la versión corregida
    exit("Nombre de archivo inválido (contiene caracteres no permitidos).");
}

// Primero verificar si está vacío (ya lo tenías, está bien)
if (empty($filename)) {
    header('HTTP/1.0 400 Bad Request');
    exit("Nombre de archivo no proporcionado.");
}

// 2. Extraer ID y Comparar
$parts = explode('_', $filename);
$file_employee_id = (count($parts) > 5) ? $parts[5] : null;

// if (!$file_employee_id || ($file_employee_id !== $employee_id && !$is_admin)) { // Habilitar si admin descarga todo
if (!$file_employee_id || $file_employee_id !== $employee_id) { // Por defecto, solo el dueño descarga
    error_log("DOWNLOAD FORBIDDEN: User {$employee_id} -> File {$filename} (ID: {$file_employee_id})");
    header('HTTP/1.0 403 Forbidden');
    exit("Acceso denegado a este archivo.");
}

// 3. Construir Ruta y Verificar
$recibos_dir = __DIR__ . '/recibos_nomina';
$filePath = $recibos_dir . '/' . $filename;

if (!file_exists($filePath) || !is_readable($filePath)) {
    error_log("DOWNLOAD NOT FOUND: " . $filePath);
    header('HTTP/1.0 404 Not Found');
    exit("Archivo no encontrado en el servidor.");
}

// 4. Enviar Cabeceras y Archivo
header('Content-Description: File Transfer');
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . basename($filename) . '"'); // Usar basename por seguridad
header('Expires: 0');
header('Cache-Control: must-revalidate');
header('Pragma: public');
header('Content-Length: ' . filesize($filePath));
ob_clean();
flush();
if (!readfile($filePath)) {
    error_log("Error en readfile para: " . $filePath);
    // Puede que ya se hayan enviado cabeceras, difícil mostrar error limpio
}
exit;
?>