<?php
// dashboard.php

// 1. Verificación de sesión PRIMERO que nada
require_once('includes/auth_check.php');

// 2. Si es admin, redirigirlo fuera del dashboard de usuario normal
if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true) {
    header("Location: admin/users_list.php");
    exit;
}

// 3. Definir título de la página (se usará en header.php)
$page_title = 'Dashboard';

// --- INICIO: Definición de Funciones Auxiliares ---

function obtenerDescripcionPeriodo($tipoPeriodo, $numeroPeriodo, $anio) {
    $meses = [
        1 => 'Enero', 2 => 'Febrero', 3 => 'Marzo', 4 => 'Abril', 5 => 'Mayo', 6 => 'Junio',
        7 => 'Julio', 8 => 'Agosto', 9 => 'Septiembre', 10 => 'Octubre', 11 => 'Noviembre', 12 => 'Diciembre'
    ];
    $numeroPeriodo = (int)$numeroPeriodo;
    $anio = htmlspecialchars($anio);
    $tipoPeriodo = trim($tipoPeriodo);

    switch (strtolower($tipoPeriodo)) {
        case 'quincenal':
            if ($numeroPeriodo >= 1 && $numeroPeriodo <= 24) {
                $indiceMes = ceil($numeroPeriodo / 2);
                $nombreMes = $meses[$indiceMes] ?? 'Mes Desc.';
                $quincena = ($numeroPeriodo % 2 != 0) ? '1ra Quincena' : '2da Quincena';
                return "$quincena $nombreMes $anio";
            } else {
                return "Quincenal - Periodo $numeroPeriodo $anio (Inválido)";
            }
            // No necesita break aquí porque return ya sale

        case 'semanal':
             return "Semana $numeroPeriodo $anio";

        case 'mensual':
             if ($numeroPeriodo >= 1 && $numeroPeriodo <= 12) {
                 $nombreMes = $meses[$numeroPeriodo] ?? 'Mes Desc.';
                 return "$nombreMes $anio";
             } else {
                 return "Mensual - Periodo $numeroPeriodo $anio (Inválido)";
             }

        case 'periodo extraordinario':
             return "Periodo Extraordinario $numeroPeriodo $anio";

        default:
            return "$tipoPeriodo - Periodo $numeroPeriodo $anio";
    }
}

function compararPeriodosDesc($archivoA, $archivoB) {
    // 1. Comparar por año (descendente)
    if ($archivoA['anio'] != $archivoB['anio']) {
        return $archivoB['anio'] <=> $archivoA['anio'];
    }
    // 2. Comparar por número de periodo (descendente, tratando Extraordinario como 99)
    $numA = (strtolower($archivoA['tipo_periodo']) == 'periodo extraordinario') ? 99 : $archivoA['num_periodo'];
    $numB = (strtolower($archivoB['tipo_periodo']) == 'periodo extraordinario') ? 99 : $archivoB['num_periodo'];
    if ($numA != $numB) {
         return $numB <=> $numA;
    }
    // 3. Desempate por nombre (ascendente)
    return $archivoA['nombre'] <=> $archivoB['nombre'];
}

// --- FIN: Definición de Funciones Auxiliares ---


// --- INICIO: Lógica PHP para preparar datos de la página ---
$company_name = "Anfitriones A.P.R."; // Necesario si footer.php lo usa
$logo_path = "/recibos_php/public/images/anfi.png"; // Necesario si header.php lo usa

// Obtener datos de la sesión
$display_name = $_SESSION['full_name'] ?? $_SESSION['username'] ?? 'Usuario';
$employee_id = $_SESSION['employee_id'] ?? null;

// Preparar variables para archivos
$user_files_data = []; // Usaremos este array para guardar toda la info
$error_files = '';
$recibos_dir = __DIR__ . '/recibos_nomina';

// Lógica para buscar archivos
if (!$employee_id) {
    $error_files = "Error: No se pudo obtener tu ID de empleado.";
    error_log("Error crítico: Falta employee_id en sesión para user_id: " . ($_SESSION['user_id'] ?? 'N/A'));
} elseif (!is_dir($recibos_dir) || !is_readable($recibos_dir)) {
    $error_files = "Error: No se puede acceder a la carpeta de recibos en este momento.";
    error_log("Error crítico: La carpeta de recibos no existe o no es legible: " . $recibos_dir);
} else {
    $files = glob($recibos_dir . "/*.{zip,rar,ZIP,RAR}", GLOB_BRACE);
    if ($files === false) {
        $error_files = "Error al leer la carpeta de recibos.";
        error_log("Error en glob() para " . $recibos_dir);
    } elseif (!empty($files)) {
        foreach ($files as $filePath) {
            $filename = basename($filePath);
            $parts = explode('_', $filename);

            if (count($parts) > 5 && isset($parts[5]) && $parts[5] == $employee_id) {
                $tipoPeriodo = $parts[2] ?? 'Desconocido';
                $anio = $parts[3] ?? '0000';
                $numeroPeriodo = $parts[4] ?? '0';
                $descripcionPeriodo = obtenerDescripcionPeriodo($tipoPeriodo, $numeroPeriodo, $anio);

                // Guardar todos los datos relevantes
                $user_files_data[] = [
                    'nombre' => $filename,
                    'periodo' => $descripcionPeriodo,
                    'anio' => (int)$anio,
                    'num_periodo' => (int)$numeroPeriodo,
                    'tipo_periodo' => $tipoPeriodo
                ];
            }
        } // Fin foreach

        // --- ¡¡AQUÍ ORDENAMOS EL ARRAY!! ---
        if (!empty($user_files_data)) {
            usort($user_files_data, 'compararPeriodosDesc');
        }
        // --- FIN DE LA ORDENACIÓN ---

    } // Fin elseif(!empty($files))
} // Fin else (carpeta existe y es legible)

// --- FIN: Lógica PHP ---


// --- Incluir Cabecera HTML ---
// (Usa $page_title, $company_name, $logo_path, datos de sesión)
require_once('includes/header.php');
?>

<h2>Tus Recibos</h2>

<?php if ($error_files): ?>
    <p class="error"><?php echo htmlspecialchars($error_files); ?></p>
<?php endif; ?>

<?php // Usar $user_files_data para verificar si hay archivos ?>
<?php if (empty($user_files_data) && !$error_files): ?>
    <p>No tienes archivos disponibles.</p>
<?php elseif (!empty($user_files_data)): ?>

    <table class="file-table">
        <thead>
            <tr>
                <th>Nombre de Archivo</th>
                <th>Periodo</th>  <th>Acción</th>
            </tr>
        </thead>
        <tbody>
            <?php // Iterar sobre el array ORDENADO $user_files_data ?>
            <?php foreach ($user_files_data as $file_data): ?>
            <tr>
                <td><?php echo htmlspecialchars($file_data['nombre']); ?></td>
                <td><?php echo htmlspecialchars($file_data['periodo']); ?></td> <td>
                    <a href="download.php?filename=<?php echo urlencode($file_data['nombre']); ?>" class="button-download">Descargar</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>

<?php endif; ?>

<?php
// Incluir Pie de Página
require_once('includes/footer.php');