<?php
require_once('../includes/admin_check.php'); // Solo admins
require_once('../config/database.php');

$users = [];
$sql = "SELECT id, username, employee_id, is_admin, full_name FROM user ORDER BY username";
$result = $conn->query($sql);

if ($result && $result->num_rows > 0) {
    while($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
}
$conn->close();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Admin - Lista de Usuarios</title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <div class="container">
        <div class="header">
             <h1>Administración de Usuarios</h1>
             <a href="../logout.php">Cerrar Sesión</a>
        </div>
        <p><a href="user_form.php">Añadir Nuevo Usuario</a></p>

        <?php if (isset($_GET['success_message'])): ?>
            <p class="success"><?php echo htmlspecialchars($_GET['success_message']); ?></p>
        <?php endif; ?>
        <?php if (isset($_GET['error_message'])): ?>
            <p class="error"><?php echo htmlspecialchars($_GET['error_message']); ?></p>
        <?php endif; ?>

        <table>
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Username</th>
                    <th>Nombre Completo</th>
                    <th>ID Empleado</th>
                    <th>Es Admin</th>
                    <th>Acciones</th>
                </tr>
            </thead>
            <tbody>
                <?php if (empty($users)): ?>
                    <tr><td colspan="5">No hay usuarios registrados.</td></tr>
                <?php else: ?>
                    <?php foreach ($users as $user): ?>
                    <tr>
                        <td><?php echo $user['id']; ?></td>
                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                        <td><?php echo htmlspecialchars($user['full_name'] ?? ''); ?></td>
                        <td><?php echo htmlspecialchars($user['employee_id']); ?></td>
                        <td><?php echo $user['is_admin'] ? 'Sí' : 'No'; ?></td>
                        <td>
                            <a href="user_form.php?id=<?php echo $user['id']; ?>">Editar</a> |
                            <a href="user_delete.php?id=<?php echo $user['id']; ?>" onclick="return confirm('ADVERTENCIA:\n¿Estás REALMENTE seguro de que quieres eliminar al usuario \'<?php echo htmlspecialchars(addslashes($user['username'])); ?>\'?\n¡Esta acción no se puede deshacer!');">Eliminar</a> |
                            <a href="bulk_upload.php?id=<?php echo $user['id']; ?>">Carga Usuarios</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</body>
</html>