<?php
require_once('../includes/admin_check.php');
require_once('../config/database.php');

$message = '';
$error = false;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Recoger datos del formulario (¡Añadir validación!)
    $user_id = $_POST['id'] ?? null; // ID para saber si es edición
    $full_name = trim($_POST['full_name'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $employee_id = trim($_POST['employee_id'] ?? '');
    $password = $_POST['password'] ?? '';
    $is_admin = isset($_POST['is_admin']) ? 1 : 0; // Checkbox si está marcado

    // Validación básica (¡Mejorar!)
    if (empty($username) || empty($employee_id)) {
        $message = "Username y ID de Empleado son obligatorios.";
        $error = true;
    }

    if (!$error) {
        if ($user_id) { // --- Editar Usuario ---
            if (!empty($password)) {
                // Actualizar con contraseña nueva
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $sql = "UPDATE user SET username = ?, employee_id = ?, password_hash = ?, is_admin = ?, full_name = ? WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sssisi", $username, $employee_id, $hashed_password, $is_admin, $full_name, $user_id);
            } else {
                // Actualizar sin cambiar contraseña
                $sql = "UPDATE user SET username = ?, employee_id = ?, is_admin = ?, full_name = ? WHERE id = ?";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("ssisi", $username, $employee_id, $is_admin, $full_name, $user_id);
            }
        } else { // --- Crear Usuario ---
            if (empty($password)) {
                $message = "La contraseña es obligatoria al crear un usuario.";
                $error = true;
            } else {
                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                $sql = "INSERT INTO user (username, employee_id, password_hash, is_admin, full_name) VALUES (?, ?, ?, ?, ?)";
                $stmt = $conn->prepare($sql);
                $stmt->bind_param("sssis", $username, $employee_id, $hashed_password, $is_admin, $full_name);
            }
        }

        // Ejecutar si no hubo error de validación previo
        if (!$error && isset($stmt)) {
             if ($stmt->execute()) {
                $message = $user_id ? "Usuario actualizado correctamente." : "Usuario creado correctamente.";
            } else {
                // Podría fallar por username o employee_id duplicado
                 $message = "Error al guardar el usuario: " . $stmt->error;
                 $error = true;
            }
            $stmt->close();
        } elseif (!$error && !isset($stmt)) {
             $message = "Error preparando la consulta."; // Error si $stmt no se creó
             $error = true;
        }
    }
    $conn->close();

    // Redirigir de vuelta a la lista con mensaje
    $param_type = $error ? 'error_message' : 'success_message';
    header("Location: users_list.php?" . $param_type . "=" . urlencode($message));
    exit;

} else {
    // Si no es POST, redirigir a la lista
    header("Location: users_list.php");
    exit;
}
?>