<?php
require_once('../includes/admin_check.php');
require_once('../config/database.php');

$user_id = $_GET['id'] ?? null;
$username = '';
$employee_id = '';
$is_admin = 0; // Por defecto no admin
$form_title = 'Añadir Nuevo Usuario';
$submit_button = 'Crear Usuario';

// Si se proporciona un ID, estamos editando
if ($user_id) {
    $form_title = 'Editar Usuario';
    $submit_button = 'Actualizar Usuario';

    $sql = "SELECT username, employee_id, is_admin, full_name FROM user WHERE id = ?";
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($result->num_rows === 1) {
            $user_data = $result->fetch_assoc();
            $username = $user_data['username'];
            $employee_id = $user_data['employee_id'];
            $is_admin = $user_data['is_admin'];
            $full_name = $user_data['full_name'];
        } else {
            // Manejar error: usuario no encontrado
            header("Location: users_list.php?error_message=Usuario no encontrado");
            exit;
        }
        $stmt->close();
    } else {
         header("Location: users_list.php?error_message=Error al preparar consulta");
         exit;
    }
}
$conn->close(); // Cerramos conexión aquí por ahora
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title><?php echo $form_title; ?></title>
    <link rel="stylesheet" href="../public/css/style.css">
</head>
<body>
    <div class="container">
        <h1><?php echo $form_title; ?></h1>
        <p><a href="users_list.php">Volver a la Lista</a></p>

        <form action="user_save.php" method="post">
            <?php if ($user_id): ?>
                <input type="hidden" name="id" value="<?php echo $user_id; ?>">
            <?php endif; ?>

            <div>
                <label for="full_name">Nombre Completo:</label>
                <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($full_name ?? ''); ?>">
            </div>

            <div>
                <label for="username">Username:</label>
                <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
            </div>
            <div>
                <label for="employee_id">ID Empleado:</label>
                <input type="text" id="employee_id" name="employee_id" value="<?php echo htmlspecialchars($employee_id); ?>" required>
            </div>
            <div>
                <label for="password">Contraseña:</label>
                <input type="password" id="password" name="password" <?php echo (!$user_id) ? 'required' : ''; ?>>
                <?php if ($user_id): ?>
                    <small>(Dejar en blanco para no cambiar)</small>
                <?php endif; ?>
            </div>
             <div>
                <label for="is_admin">¿Es Administrador?</label>
                <input type="checkbox" id="is_admin" name="is_admin" value="1" <?php echo ($is_admin == 1) ? 'checked' : ''; ?>>
            </div>
            <div>
                <button type="submit"><?php echo $submit_button; ?></button>
            </div>
        </form>
    </div>
</body>
</html>