<?php
require_once('../includes/admin_check.php');
require_once('../config/database.php');

$user_id = $_GET['id'] ?? null;
$message = '';
$error = false;

// ¡¡¡Falta una confirmación aquí!!! En una app real, añade un paso intermedio.
if ($user_id) {
    // Prevenir borrado del propio admin (o usuario ID 1, por ejemplo)
    if ($user_id == $_SESSION['user_id']) {
         $message = "No puedes eliminar tu propia cuenta.";
         $error = true;
    } else {
        $sql = "DELETE FROM user WHERE id = ?";
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("i", $user_id);
            if ($stmt->execute()) {
                // Verificar si realmente se borró algo
                if ($stmt->affected_rows > 0) {
                     $message = "Usuario eliminado correctamente.";
                } else {
                     $message = "Usuario no encontrado o ya eliminado.";
                     $error = true; // Considerarlo error si no se afectaron filas
                }
            } else {
                $message = "Error al eliminar el usuario: " . $stmt->error;
                $error = true;
            }
            $stmt->close();
        } else {
             $message = "Error preparando la consulta de eliminación.";
             $error = true;
        }
    }
} else {
    $message = "No se proporcionó ID de usuario para eliminar.";
    $error = true;
}

$conn->close();

// Redirigir de vuelta a la lista con mensaje
$param_type = $error ? 'error_message' : 'success_message';
header("Location: users_list.php?" . $param_type . "=" . urlencode($message));
exit;
?>