<?php
// supervisor/dashboard.php

require_once('../includes/supervisor_check.php'); 
require_once('../config/database.php'); 
require_once('../includes/functions.php'); // Para CSRF y otras funciones

$page_title = 'Panel de Supervisión de Recibos';

$reset_success_message = $_SESSION['reset_success_message'] ?? null;
$reset_error_message = $_SESSION['reset_error_message'] ?? null;
unset($_SESSION['reset_success_message']);
unset($_SESSION['reset_error_message']);

$employees_list = [];
$sql_employees = "SELECT id, employee_id, full_name FROM user 
                  WHERE is_admin = 0 AND is_supervisor = 0 
                  ORDER BY full_name ASC";
$result_employees = $conn->query($sql_employees);
if ($result_employees && $result_employees->num_rows > 0) {
    while ($row = $result_employees->fetch_assoc()) {
        $employees_list[] = $row;
    }
}

$selected_employee_user_id = filter_input(INPUT_GET, 'selected_employee_user_id', FILTER_VALIDATE_INT);
if (empty($selected_employee_user_id) && isset($_SESSION['last_selected_employee_for_supervisor'])) {
    $selected_employee_user_id = $_SESSION['last_selected_employee_for_supervisor'];
} else if ($selected_employee_user_id) {
    $_SESSION['last_selected_employee_for_supervisor'] = $selected_employee_user_id;
}

$selected_employee_payslips_data = []; 
$selected_employee_info = null;
$cartas_y_estado_map = [];

if ($selected_employee_user_id) {
    // ... (Lógica para obtener $selected_employee_info y $cartas_y_estado_map como la tenías) ...
    // ... (Lógica para obtener $selected_employee_payslips_data como la tenías, asegurando que use las funciones actualizadas
    //      y la comparación de ID de empleado correcta) ...
    // Esta parte es la misma que la última versión funcional que tenías.
    // Por brevedad, la omito aquí, pero debe estar presente y correcta.
    // Asegúrate de que esta lógica esté completa y funcional:
    $stmt_selected_employee = $conn->prepare("SELECT id, full_name, employee_id FROM user WHERE id = ? AND is_admin = 0 AND is_supervisor = 0");
    if ($stmt_selected_employee) {
        $stmt_selected_employee->bind_param("i", $selected_employee_user_id);
        $stmt_selected_employee->execute();
        $result_se = $stmt_selected_employee->get_result();
        if ($emp_data = $result_se->fetch_assoc()) {
            $selected_employee_info = $emp_data;
            $sql_aceptados_cartas = "SELECT nombre_archivo_recibo, ruta_carta_aceptacion FROM descargas_recibos WHERE id_usuario = ? AND ruta_carta_aceptacion IS NOT NULL";
            $stmt_ac_cartas = $conn->prepare($sql_aceptados_cartas);
            if ($stmt_ac_cartas) {
                $stmt_ac_cartas->bind_param("i", $selected_employee_info['id']);
                $stmt_ac_cartas->execute();
                $result_ac_cartas = $stmt_ac_cartas->get_result();
                while ($row_ac = $result_ac_cartas->fetch_assoc()) {
                    $cartas_y_estado_map[$row_ac['nombre_archivo_recibo']] = ['estado_aceptado' => true, 'ruta_carta' => $row_ac['ruta_carta_aceptacion']];
                }
                $stmt_ac_cartas->close();
            }
            $recibos_dir_supervisor = __DIR__ . '/../recibos_nomina';
            $employee_id_nomina_a_buscar = $selected_employee_info['employee_id'];
            $files_for_employee = glob($recibos_dir_supervisor . "/*.*", GLOB_BRACE);
            if ($files_for_employee !== false && !empty($files_for_employee)) {
                foreach ($files_for_employee as $filePath) {
                    $filename = basename($filePath);
                    $parts = explode('_', $filename);
                    $file_emp_id_from_name_str = null;
                    if (count($parts) > 5 && isset($parts[5])) {
                        $id_part_raw = $parts[5];
                        $file_emp_id_from_name_str = trim(pathinfo($id_part_raw, PATHINFO_FILENAME));
                        if (!is_numeric($file_emp_id_from_name_str)) { 
                            if (preg_match('/^(\d+)/', $id_part_raw, $id_matches)) { $file_emp_id_from_name_str = $id_matches[1]; } 
                            else { $file_emp_id_from_name_str = null; }
                        }
                    }
                    if ($file_emp_id_from_name_str !== null && (int)$file_emp_id_from_name_str == (int)$employee_id_nomina_a_buscar) {
                        $tipoPeriodo = trim($parts[2] ?? 'Desconocido');
                        $anio_file = (int)($parts[3] ?? 0);
                        $numeroPeriodo_file = (int)($parts[4] ?? 0);
                        $descripcionPeriodo = obtenerDescripcionPeriodo($tipoPeriodo, $numeroPeriodo_file, $anio_file);
                        $estado_info = $cartas_y_estado_map[$filename] ?? ['estado_aceptado' => false, 'ruta_carta' => null];
                        $selected_employee_payslips_data[] = [
                            'nombre' => $filename, 'periodo' => $descripcionPeriodo, 'anio' => $anio_file,
                            'num_periodo' => $numeroPeriodo_file, 'tipo_periodo' => $tipoPeriodo,
                            'mes_numero' => obtenerNumeroMes($tipoPeriodo, $numeroPeriodo_file),
                            'estado_aceptado' => $estado_info['estado_aceptado'], 'ruta_carta' => $estado_info['ruta_carta']
                        ];
                    }
                }
                if (!empty($selected_employee_payslips_data)) usort($selected_employee_payslips_data, 'compararPeriodosDesc');
            }
        } else { $selected_employee_info = ['full_name' => "Empleado no encontrado o no es un empleado válido."]; }
        $stmt_selected_employee->close();
    } else {
        error_log("SUPERVISOR_DASH: Error al preparar consulta datos empleado: " . $conn->error);
        $selected_employee_info = ['full_name' => "Error al consultar empleado."];
    }
}

// Generar token CSRF para los formularios de acción en esta página
$csrf_token_supervisor_actions = generate_csrf_token();

require_once('../includes/header.php'); 
?>
<main class="container main-container-flex-column">
    <h2><?php echo htmlspecialchars($page_title); ?></h2>

    <?php if ($reset_success_message): ?>
        <p class="success" style="margin-bottom:15px;"><?php echo htmlspecialchars($reset_success_message); ?></p>
    <?php endif; ?>
    <?php if ($reset_error_message): ?>
        <p class="error" style="margin-bottom:15px;"><?php echo htmlspecialchars($reset_error_message); ?></p>
    <?php endif; ?>

    <form method="GET" action="dashboard.php" class="filter-form" style="margin-bottom: 25px; padding: 15px; background-color: #f8f9fa; border-radius: 6px;">
        <fieldset style="border: none; padding: 0; margin: 0;">
            <legend style="font-size: 1.1em; font-weight: 600; margin-bottom: 10px;">Ver Recibos de Empleado</legend>
            <div class="form-group" style="display: flex; align-items: center; gap: 10px;">
                <label for="selected_employee_user_id" style="margin-bottom: 0; white-space: nowrap;">Seleccionar Empleado:</label>
                <select name="selected_employee_user_id" id="selected_employee_user_id" onchange="this.form.submit();" style="flex-grow: 1; padding: 8px; border-radius: 4px; border: 1px solid #ced4da;">
                    <option value="">-- Elige un empleado --</option>
                    <?php foreach ($employees_list as $employee): ?>
                        <option value="<?php echo $employee['id']; ?>" <?php echo ($selected_employee_user_id == $employee['id']) ? 'selected' : ''; ?>>
                            <?php echo htmlspecialchars($employee['full_name']); ?> (ID Nómina: <?php echo htmlspecialchars($employee['employee_id']); ?>)
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
        </fieldset>
        <fieldset style="border: none; padding: 0; margin: 0; margin-top:25px;">
            <legend style="font-size: 1.1em; font-weight: 600; margin-bottom: 10px;">Carga de Usuarios en Modo Masivo (Empleados)</legend>
            <div style="margin-bottom: 20px;">
                <a href="bulk_upload_supervisor.php" class="button">Cargar Usuarios Masivamente (Empleados)</a>
            </div>
        </fieldset>
    </form>
    
    <div class="admin-actions" style="margin-top: 1rem; margin-bottom: 2rem; padding-top: 1rem; border-top: 1px solid #eee;">
        <a href="upload_receipts.php" class="button button-secondary">Cargar Recibos de Nómina</a>
    </div>

    <?php if ($selected_employee_user_id && $selected_employee_info && isset($selected_employee_info['full_name']) && $selected_employee_info['full_name'] !== "Empleado no encontrado o no es un empleado válido." && $selected_employee_info['full_name'] !== "Error al consultar empleado."): ?>
        <h3 style="margin-top: 30px; border-bottom: 1px solid #eee; padding-bottom: 10px;">
            Mostrando Recibos de: <strong><?php echo htmlspecialchars($selected_employee_info['full_name']); ?></strong>
            (ID Nómina: <?php echo htmlspecialchars($selected_employee_info['employee_id']); ?>)
        </h3>
        <?php if (!empty($selected_employee_payslips_data)):
            // ... (cálculo de $total_recibos, $aceptados_count, $pendientes_count como lo tenías) ...
            $total_recibos = count($selected_employee_payslips_data);
            $aceptados_count = 0;
            foreach ($selected_employee_payslips_data as $p_count) { if ($p_count['estado_aceptado']) $aceptados_count++; }
            $pendientes_count = $total_recibos - $aceptados_count;
        ?>
            <p style="margin-bottom: 15px; font-size: 0.95em;">
                Total de recibos: <strong><?php echo $total_recibos; ?></strong> | 
                Aceptados: <strong style="color: green;"><?php echo $aceptados_count; ?></strong> | 
                Pendientes: <strong style="color: orange;"><?php echo $pendientes_count; ?></strong>
            </p>

            <div class="table-scroll-container">
                <table class="file-table">
                    <thead>
                        <tr>
                            <th>Nombre de Archivo</th>
                            <th>Periodo</th>
                            <th>Estado Aceptación</th>
                            <th>Carta Aceptación</th>
                            <th>Acciones</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($selected_employee_payslips_data as $payslip): ?>
                            <tr>
                                <td><?php echo htmlspecialchars($payslip['nombre']); ?></td>
                                <td><?php echo htmlspecialchars($payslip['periodo']); ?></td>
                                <td>
                                    <?php if ($payslip['estado_aceptado']): ?>
                                        <span class="status-descargado">✔ Aceptado</span>
                                    <?php else: ?>
                                        <span class="status-pendiente">▫ Pendiente</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php if ($payslip['estado_aceptado'] && !empty($payslip['ruta_carta'])): ?>
                                        <a href="../download_carta.php?carta=<?php echo urlencode($payslip['ruta_carta']); ?>&uid=<?php echo $selected_employee_info['id']; ?>" 
                                           class="button button-small button-outline" target="_blank">
                                           Ver Carta
                                        </a>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <?php // ESTA ES LA CONDICIÓN IMPORTANTE PARA EL BOTÓN RESETEAR ?>
                                    <?php if ($payslip['estado_aceptado']): ?>
                                        <form action="../reset_aceptacion.php" method="POST" style="display: inline;" 
                                              onsubmit="return confirm('¿Estás seguro de que quieres resetear la aceptación para este recibo?\n\'<?php echo htmlspecialchars(addslashes($payslip['nombre'])); ?>\' para el empleado <?php echo htmlspecialchars(addslashes($selected_employee_info['full_name'])); ?>.\nEl empleado deberá volver a aceptar la declaratoria.\nLa carta de aceptación actual será eliminada.');">
                                            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token_supervisor_actions); ?>">
                                            <input type="hidden" name="employee_user_id_to_reset" value="<?php echo $selected_employee_info['id']; ?>">
                                            <input type="hidden" name="payslip_name_to_reset" value="<?php echo htmlspecialchars($payslip['nombre']); ?>">
                                            <input type="hidden" name="redirect_back_to" value="supervisor_dashboard"> 
                                            <button type="submit" class="button button-small button-danger-outline">Resetear</button>
                                        </form>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <p>No se encontraron recibos para el empleado: <?php echo htmlspecialchars($selected_employee_info['full_name']); ?>.</p>
        <?php endif; ?>
    <?php elseif ($selected_employee_user_id && $selected_employee_info): ?>
        <p class="error" style="padding: 10px; background-color: #f8d7da; border: 1px solid #f5c6cb; color: #721c24; border-radius: 4px;">
            <?php echo htmlspecialchars($selected_employee_info['full_name']); ?>
        </p>
    <?php elseif ($selected_employee_user_id): ?>
        <p>Por favor, selecciona un empleado válido de la lista.</p> 
    <?php endif; ?>
</main>
<?php 
require_once('../includes/footer.php'); 
if(isset($conn) && $conn instanceof mysqli) $conn->close();
?>