<?php
// supervisor/bulk_upload_supervisor.php

require_once('../includes/supervisor_check.php'); 
$page_title = 'Supervisor - Carga Masiva de Usuarios';

require_once('../includes/functions.php'); 

// Leer mensajes y datos de la sesión para mostrar después de una redirección POST->GET
$upload_message_display = $_SESSION['sv_bulk_upload_message_display'] ?? null;
$error_message_display = $_SESSION['sv_bulk_upload_error_message_display'] ?? null;
$info_message_display = $_SESSION['sv_bulk_upload_info_message_display'] ?? null;
$users_processed_details_display = $_SESSION['sv_bulk_upload_summary_display'] ?? [];
$errors_details_display = $_SESSION['sv_bulk_upload_errors_details_display'] ?? [];
$success_count_display = $_SESSION['sv_bulk_upload_success_count_display'] ?? 0;
$updated_count_display = $_SESSION['sv_bulk_upload_updated_count_display'] ?? 0; // Nuevo
$skipped_count_display = $_SESSION['sv_bulk_upload_skipped_count_display'] ?? 0; // Nuevo
$error_count_display = $_SESSION['sv_bulk_upload_error_count_display'] ?? 0;

unset(
    $_SESSION['sv_bulk_upload_message_display'], $_SESSION['sv_bulk_upload_error_message_display'],
    $_SESSION['sv_bulk_upload_info_message_display'], $_SESSION['sv_bulk_upload_summary_display'],
    $_SESSION['sv_bulk_upload_errors_details_display'], $_SESSION['sv_bulk_upload_success_count_display'],
    $_SESSION['sv_bulk_upload_updated_count_display'], $_SESSION['sv_bulk_upload_skipped_count_display'],
    $_SESSION['sv_bulk_upload_error_count_display']
);

// Lógica para Descargar Resumen CSV
if (isset($_GET['action']) && $_GET['action'] === 'download_summary' && isset($_SESSION['bulk_upload_summary_data_sv'])) {
    $summary_data = $_SESSION['bulk_upload_summary_data_sv'];
    unset($_SESSION['bulk_upload_summary_data_sv']); 

    if (!empty($summary_data)) {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="resumen_carga_supervisor_' . date('Ymd_His') . '.csv"');
        $output = fopen('php://output', 'w');
        fputcsv($output, ['Username', 'Nombre Completo', 'ID Empleado', 'Email(s)', 'Contraseña Generada', 'Estado Proceso']);
        foreach ($summary_data as $user_detail) {
            fputcsv($output, [
                $user_detail['username'],
                $user_detail['full_name'],
                $user_detail['employee_id'],
                $user_detail['email'],
                $user_detail['generated_password'] ?? 'N/A (Existente/Actualizado)',
                $user_detail['process_status']
                // $user_detail['email_status'] // Ya no enviamos email automático desde aquí
            ]);
        }
        fclose($output);
        exit;
    } else {
        $_SESSION['sv_bulk_upload_error_message_display'] = "No hay datos de resumen para descargar o la sesión expiró.";
        header("Location: bulk_upload_supervisor.php");
        exit;
    }
}

$csrf_token = generate_csrf_token(); 
require_once('../includes/header.php'); 
?>
<main class="container">
    <h2><?php echo htmlspecialchars($page_title); ?></h2>
    <p><a href="dashboard.php" class="button button-outline">&laquo; Volver al Dashboard de Supervisor</a></p>

    <?php if ($upload_message_display): ?>
        <p class="success" style="white-space: pre-wrap;"><?php echo htmlspecialchars($upload_message_display); ?></p>
    <?php endif; ?>
    <?php if ($error_message_display): ?>
        <p class="error"><?php echo htmlspecialchars($error_message_display); ?></p>
    <?php endif; ?>
    <?php if ($info_message_display): ?>
        <p style="padding: 10px; background-color: #e6f7ff; border: 1px solid #b3e0ff; color: #005f99; border-radius: 4px;"><?php echo htmlspecialchars($info_message_display); ?></p>
    <?php endif; ?>

    <?php if (!empty($users_processed_details_display)): ?>
        <div class="processed-users-summary" style="margin-top: 20px; margin-bottom:20px; border: 1px solid #ccc; padding: 15px; border-radius: 5px;">
            <h3>
                Resumen del Procesamiento: 
                <?php 
                $summary_parts = [];
                if ($success_count_display > 0) $summary_parts[] = "{$success_count_display} Creados";
                if ($updated_count_display > 0) $summary_parts[] = "{$updated_count_display} Actualizados";
                if ($skipped_count_display > 0) $summary_parts[] = "{$skipped_count_display} Omitidos (ya existían)";
                echo implode(', ', $summary_parts);
                ?>
            </h3>
            <?php if ($success_count_display > 0): ?>
            <p><strong>IMPORTANTE:</strong> Para usuarios nuevos, anote las contraseñas generadas y comuníquelas de forma segura. Deberán cambiarla en su primer inicio de sesión.</p>
            <?php endif; ?>
            
            <?php if($success_count_display > 0 || $updated_count_display > 0 || $skipped_count_display > 0) : ?>
            <div style="margin-bottom: 15px; text-align: right;">
                <a href="bulk_upload_supervisor.php?action=download_summary" class="button button-secondary">Descargar Resumen como CSV</a>
            </div>
            <?php endif; ?>

            <div class="table-scroll-container" style="max-height: 300px;">
                <table class="file-table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Nombre Completo</th>
                            <th>ID Empleado</th>
                            <th>Email(s)</th>
                            <th>Contraseña Generada</th>
                            <th>Estado del Proceso</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users_processed_details_display as $detail): ?>
                            <tr style="<?php 
                                if(strpos(strtolower($detail['process_status']), 'error') !== false) echo 'background-color: #ffebee;'; 
                                elseif($detail['process_status'] === 'Actualizado') echo 'background-color: #e3f2fd;'; 
                                elseif($detail['process_status'] === 'Omitido (ya existe)') echo 'background-color: #fff9c4;';
                                ?>">
                                <td><?php echo htmlspecialchars($detail['username']); ?></td>
                                <td><?php echo htmlspecialchars($detail['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($detail['employee_id']); ?></td>
                                <td><?php echo htmlspecialchars($detail['email'] ?? 'N/A'); ?></td>
                                <td>
                                    <?php if (!empty($detail['generated_password'])): ?>
                                        <strong><?php echo htmlspecialchars($detail['generated_password']); ?></strong>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($detail['process_status']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($errors_details_display)): ?>
        <div class="error-details" style="border:1px solid #dc3545; padding: 10px; margin-bottom:15px; background-color:#f8d7da; border-radius:4px;">
            <h4>Detalles de Errores en Filas (<?php echo $error_count_display; ?>):</h4>
            <ul style="max-height: 200px; overflow-y: auto; list-style-position: inside; padding-left: 15px;">
                <?php foreach ($errors_details_display as $detail): ?>
                    <li><?php echo htmlspecialchars($detail); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="process_bulk_supervisor.php" method="post" enctype="multipart/form-data" style="margin-top: 20px;">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>"> 
        <p>Selecciona un archivo CSV para subir. La primera línea debe ser la cabecera con los siguientes nombres de columna (el orden puede variar, pero deben estar todas):<br>
            <strong>codigo, nombre_completo, username, email</strong>
        </p>
        <p><small>La contraseña para cada usuario nuevo se generará automáticamente. Para usuarios existentes, la contraseña no se modificará mediante este proceso.</small></p>
        
        <div class="form-group">
            <label for="user_csv">Archivo CSV:</label>
            <input type="file" name="user_csv" id="user_csv" accept=".csv, text/csv, application/csv, application/vnd.ms-excel, text/plain" required>
        </div>

        <div class="form-group" style="margin-top: 10px; margin-bottom: 15px;">
            <input type="checkbox" id="update_existing_sv" name="update_existing_sv" value="1" style="width: auto; vertical-align: middle; margin-right: 5px;">
            <label for="update_existing_sv" style="display: inline; font-weight: normal;">Actualizar información (Nombre, Email) de usuarios existentes si se encuentran en el CSV.</label>
            <small style="display:block; margin-top: 5px;">Si no se marca, los usuarios existentes en el CSV serán omitidos.</small>
        </div>
        
        <div class="form-group">
            <button type="submit" class="button">Subir y Procesar Usuarios</button> 
        </div>
    </form>
    <p style="margin-top: 20px;"><small>
        Nota: Si un 'username' o 'codigo' (ID Empleado) en una fila para un nuevo usuario ya existe, esa fila específica dará error y no se creará.
        Si opta por actualizar, los usuarios existentes solo modificarán su nombre y email.
    </small></p>
</main>
<?php
require_once('../includes/footer.php');
?>