<?php
// reset_aceptacion.php

// 1. Incluir verificadores y configuraciones
require_once('includes/supervisor_check.php'); // Solo supervisores o admins pueden acceder
require_once('config/database.php');       
require_once('includes/functions.php');       // Para validate_csrf_token

$_SESSION['reset_error_message'] = null;   // Usaremos estos para los mensajes en supervisor/dashboard
$_SESSION['reset_success_message'] = null;
$_SESSION['reset_warning_message'] = null; // Para warnings como no poder borrar el archivo PDF

// Para redirigir al mismo empleado después de la operación
$employee_to_redirect_to = $_POST['employee_user_id_to_reset'] ?? ($_SESSION['last_selected_employee_for_supervisor'] ?? null);


// 2. Verificar que la solicitud sea POST y Validar Token CSRF
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        $_SESSION['reset_error_message'] = "Error de validación de seguridad (CSRF). La acción no se realizó.";
        error_log("RESET_ACEPTACION: CSRF token validation failed. User ID making request: " . ($_SESSION['user_id'] ?? 'N/A'));
        $redirect_url = "supervisor/dashboard.php" . ($employee_to_redirect_to ? "?selected_employee_user_id=" . $employee_to_redirect_to : "");
        header("Location: " . $redirect_url);
        exit;
    }

    // Si el token es válido, continuar...
    $employee_user_id_to_reset = filter_input(INPUT_POST, 'employee_user_id_to_reset', FILTER_VALIDATE_INT);
    $payslip_name_to_reset = filter_input(INPUT_POST, 'payslip_name_to_reset', FILTER_SANITIZE_SPECIAL_CHARS);
    // $redirect_back_to = filter_input(INPUT_POST, 'redirect_back_to', FILTER_SANITIZE_SPECIAL_CHARS); // Podríamos usarlo si es más genérico

    if (empty($employee_user_id_to_reset) || empty($payslip_name_to_reset)) {
        $_SESSION['reset_error_message'] = "Faltan datos para resetear la aceptación del recibo.";
        error_log("RESET_ACEPTACION: Datos POST incompletos. UserID: {$employee_user_id_to_reset}, Recibo: {$payslip_name_to_reset}");
    } else {
        // Guardar para la redirección final
        $_SESSION['last_selected_employee_for_supervisor'] = $employee_user_id_to_reset;

        if ($conn) {
            $conn->begin_transaction();
            try {
                $ruta_carta_a_borrar = null;
                $sql_get_carta = "SELECT ruta_carta_aceptacion FROM descargas_recibos WHERE id_usuario = ? AND nombre_archivo_recibo = ?";
                $stmt_get = $conn->prepare($sql_get_carta);
                if (!$stmt_get) throw new Exception("Error preparando consulta para obtener ruta de carta: " . $conn->error);
                
                $stmt_get->bind_param("is", $employee_user_id_to_reset, $payslip_name_to_reset);
                $stmt_get->execute();
                $result_get = $stmt_get->get_result();
                if ($row_get = $result_get->fetch_assoc()) {
                    $ruta_carta_a_borrar = $row_get['ruta_carta_aceptacion'];
                }
                $stmt_get->close();

                $sql_delete = "DELETE FROM descargas_recibos WHERE id_usuario = ? AND nombre_archivo_recibo = ?";
                $stmt_delete = $conn->prepare($sql_delete);
                if (!$stmt_delete) throw new Exception("Error preparando consulta para eliminar registro: " . $conn->error);
                
                $stmt_delete->bind_param("is", $employee_user_id_to_reset, $payslip_name_to_reset);
                if (!$stmt_delete->execute()) {
                    throw new Exception("Error al eliminar el registro de aceptación de la BD: " . $stmt_delete->error);
                }

                if ($stmt_delete->affected_rows > 0) {
                    if (!empty($ruta_carta_a_borrar)) {
                        $directorio_cartas = __DIR__ . '/cartas_aceptacion/';
                        $ruta_completa_pdf_a_borrar = $directorio_cartas . basename($ruta_carta_a_borrar);
                        if (file_exists($ruta_completa_pdf_a_borrar)) {
                            if (!unlink($ruta_completa_pdf_a_borrar)) {
                                error_log("RESET_ACEPTACION: No se pudo eliminar el archivo PDF: " . $ruta_completa_pdf_a_borrar);
                                $_SESSION['reset_warning_message'] = "Aceptación reseteada en BD, pero no se eliminó el PDF de la carta. Contacte al admin.";
                            }
                        } else {
                            error_log("RESET_ACEPTACION: Archivo PDF de carta no encontrado para eliminar: " . $ruta_completa_pdf_a_borrar);
                        }
                    }
                    $_SESSION['reset_success_message'] = "La aceptación del recibo '" . htmlspecialchars($payslip_name_to_reset) . "' ha sido reseteada.";
                    $conn->commit();
                } else {
                    $_SESSION['reset_error_message'] = "No se encontró un registro de aceptación para el recibo '" . htmlspecialchars($payslip_name_to_reset) . "' (o ya fue reseteado).";
                    $conn->rollback();
                }
                $stmt_delete->close();

            } catch (Exception $e) {
                $conn->rollback();
                $_SESSION['reset_error_message'] = "Error en el proceso de reseteo: " . $e->getMessage();
                error_log("RESET_ACEPTACION: Excepción: " . $e->getMessage());
            }
        } else {
            $_SESSION['reset_error_message'] = "Error: No se pudo conectar a la base de datos.";
            error_log("RESET_ACEPTACION: Falla de conexión a BD.");
        }
    }
} else {
    $_SESSION['reset_error_message'] = "Acceso no válido para esta operación.";
}

if (isset($conn) && $conn instanceof mysqli) $conn->close();

// Redirigir de vuelta al dashboard del supervisor, mostrando el empleado que se estaba viendo
$redirect_url = "supervisor/dashboard.php";
if ($employee_to_redirect_to) {
    $redirect_url .= "?selected_employee_user_id=" . $employee_to_redirect_to;
}
header("Location: " . $redirect_url);
exit;
?>