<?php
// mostrar_declaratoria.php

require_once('includes/auth_check.php');
require_once('config/database.php');
require_once('includes/functions.php'); // Asegúrate que functions.php tenga generate_csrf_token()

// Configuración de la empresa
$nombre_empresa_cliente = "CORPORATIVO EMPRESARIAL";
$ruta_logo_cliente_web = "public/images/logo_corporativo.png"; // Ruta para mostrar en web, usada en HTML
// $ruta_logo_cliente_fpdf ya no se usa aquí, se usará en procesar_aceptacion...

// Datos del empleado
$nombre_empleado = $_SESSION['full_name'] ?? 'Empleado';
$id_empleado_nomina_original = $_SESSION['employee_id'] ?? null;
$user_id_actual = $_SESSION['user_id'] ?? null;

if ($id_empleado_nomina_original === null || $user_id_actual === null) {
    error_log("MOSTRAR_DECL: Falta employee_id o user_id en sesión.");
    die("Error crítico: No se pudo obtener la información del empleado desde la sesión.");
}
// El formateo de $id_empleado_nomina_formateado se usa para buscar archivos.
// Lo mantenemos si los nombres de archivo usan el ID formateado.
// Si los nombres de archivo usan el ID tal cual (ej. 1003), este formateo podría no ser necesario para el glob.
// Por ahora, lo dejamos como estaba en tu código original.
$id_empleado_nomina_formateado = sprintf("%03d", (int)$id_empleado_nomina_original); 

$recibos_a_firmar_desc = [];
$archivos_para_procesar_nombres = [];
// $parametros_descarga_final_url = ""; // No se usa directamente aquí para redirigir, sino para pasar datos
$tipo_descarga = '';
$nombre_archivo_original_para_form = null; // Para el input hidden si es descarga individual

if (isset($_GET['recibo_individual'])) {
    $tipo_descarga = 'individual';
    $nombre_archivo_original_para_form = filter_input(INPUT_GET, 'recibo_individual', FILTER_SANITIZE_SPECIAL_CHARS);
    if (empty($nombre_archivo_original_para_form)) {
        error_log("MOSTRAR_DECL: Nombre de archivo individual vacío.");
        // Redirigir con mensaje de error
        $_SESSION['error_message'] = "Error: Nombre de archivo individual no especificado.";
        header("Location: dashboard.php");
        exit;
    }
    $archivos_para_procesar_nombres[] = $nombre_archivo_original_para_form;
    // $parametros_descarga_final_url ya no se construye aquí para redirección directa

} elseif (isset($_GET['descarga_masiva']) && $_GET['descarga_masiva'] == '1') {
    $tipo_descarga = 'masiva';
    $filter_month_from_str = filter_input(INPUT_GET, 'filter_month_from', FILTER_SANITIZE_SPECIAL_CHARS);
    $filter_month_to_str = filter_input(INPUT_GET, 'filter_month_to', FILTER_SANITIZE_SPECIAL_CHARS);

    // La lógica para obtener $archivos_para_procesar_nombres en descarga masiva (tu código original está bien)
    // ... (tu lógica de glob y filtrado para masiva) ...
    // Asegúrate que $id_empleado_nomina_formateado se use consistentemente aquí si tus archivos lo necesitan.
    // Si tu glob o el parseo del nombre de archivo depende del ID sin formatear, ajusta.
    $start_year_month = null;
    if ($filter_month_from_str && preg_match('/^(\d{4})-(\d{2})$/', $filter_month_from_str, $m)) $start_year_month = (int)$m[1] * 100 + (int)$m[2];
    $end_year_month = null;
    if ($filter_month_to_str && preg_match('/^(\d{4})-(\d{2})$/', $filter_month_to_str, $m)) $end_year_month = (int)$m[1] * 100 + (int)$m[2];

    $recibos_dir = __DIR__ . '/recibos_nomina';
    // Asumiremos que el ID en el nombre del archivo puede tener más de 3 dígitos y no siempre está formateado con ceros.
    // Por lo tanto, el glob podría necesitar ser más general y el filtrado más específico.
    // O, si los archivos SIEMPRE usan el ID formateado, $id_empleado_nomina_formateado es correcto para el patrón.
    // Por ahora, mantendré tu $pattern original con $id_empleado_nomina_formateado.
    $pattern = $recibos_dir . "/*_" . $id_empleado_nomina_formateado . "_*.*";
    $potential_files = glob($pattern, GLOB_BRACE);

    if($potential_files) {
        foreach ($potential_files as $filePath) {
            $filename = basename($filePath);
            $parts = explode('_', $filename);
            $file_emp_id_from_name_str = null;
            // Ajustar esta extracción si el formato del ID en el nombre del archivo es diferente
            if (count($parts) > 5 && isset($parts[5])) {
                $id_part_raw = $parts[5];
                $file_emp_id_from_name_str = trim(pathinfo($id_part_raw, PATHINFO_FILENAME));
                // Si el ID en el archivo no tiene ceros a la izquierda pero $id_empleado_nomina_formateado sí,
                // o viceversa, la comparación puede fallar.
                // Es mejor comparar como enteros o asegurar formatos consistentes.
                // Por ahora, mantenemos tu comparación original $file_emp_id_from_name_str === $id_empleado_nomina_formateado
            }

            if ($file_emp_id_from_name_str === $id_empleado_nomina_formateado) { // Esta comparación podría necesitar ajuste
                $tipoPeriodo = trim($parts[2] ?? 'Desconocido');
                $anio_file = (int)($parts[3] ?? 0);
                $numeroPeriodo_file = (int)($parts[4] ?? 0);
                $mes_archivo = obtenerNumeroMes($tipoPeriodo, $numeroPeriodo_file);
                
                $pasarFiltro = true;
                if ($mes_archivo !== null) { // Recibos con mes definido
                    $file_year_month = $anio_file * 100 + $mes_archivo;
                    if ($start_year_month !== null && $file_year_month < $start_year_month) $pasarFiltro = false;
                    if ($pasarFiltro && $end_year_month !== null && $file_year_month > $end_year_month) $pasarFiltro = false;
                } elseif ($start_year_month !== null || $end_year_month !== null) { // Recibos sin mes definido (ej. Extraordinario) y hay filtro de mes
                    $pasarFiltro = false;
                }
                
                if ($pasarFiltro) {
                    $archivos_para_procesar_nombres[] = $filename;
                }
            }
        }
    }
    // Fin lógica de glob

} else {
    error_log("MOSTRAR_DECL: Tipo de descarga no reconocido o falta parámetro. GET: " . print_r($_GET, true));
    $_SESSION['error_message'] = "Error: No se especificó el tipo de descarga o los parámetros necesarios.";
    header("Location: dashboard.php");
    exit;
}

// --- Lógica de verificación de firmas (tu código original) ---
$archivos_pendientes_de_firma_nombres = [];
$todos_ya_firmados = true; // Asumir que todos están firmados hasta que se encuentre uno pendiente

if (empty($archivos_para_procesar_nombres)) {
    if ($tipo_descarga == 'masiva') {
        $_SESSION['info_message'] = "No se encontraron recibos que coincidan con los filtros para la descarga masiva.";
    } else { // Individual
        $_SESSION['error_message'] = "El recibo solicitado no se pudo procesar o no se encontró.";
    }
    header("Location: dashboard.php");
    exit;
}

if ($conn) {
    foreach ($archivos_para_procesar_nombres as $nombre_f) {
        $stmt_check = $conn->prepare("SELECT id FROM descargas_recibos WHERE id_usuario = ? AND nombre_archivo_recibo = ? AND ruta_carta_aceptacion IS NOT NULL AND ruta_carta_aceptacion <> ''");
        if ($stmt_check) {
            $stmt_check->bind_param("is", $user_id_actual, $nombre_f);
            $stmt_check->execute();
            $stmt_check->store_result();
            if ($stmt_check->num_rows == 0) { // Si no hay registro con carta, está pendiente de firma
                $archivos_pendientes_de_firma_nombres[] = $nombre_f;
                $todos_ya_firmados = false;
            }
            $stmt_check->close();
        } else {
            error_log("MOSTRAR_DECL: Error preparando consulta para verificar firma: " . $conn->error);
            $archivos_pendientes_de_firma_nombres[] = $nombre_f; 
            $todos_ya_firmados = false;
        }
    }
} else {
    error_log("MOSTRAR_DECL: No hay conexión a BD para verificar firmas.");
    $archivos_pendientes_de_firma_nombres = $archivos_para_procesar_nombres; // Asumir todos pendientes si no hay BD
    $todos_ya_firmados = empty($archivos_pendientes_de_firma_nombres);
}
// --- Fin lógica de verificación de firmas ---

// Si todos los recibos a procesar YA ESTÁN FIRMADOS, iniciar descarga directamente y redirigir a dashboard
if ($todos_ya_firmados && !empty($archivos_para_procesar_nombres)) {
    $_SESSION['success_message'] = "Todos los recibos seleccionados ya fueron aceptados previamente. Iniciando descarga...";
    if ($tipo_descarga == 'individual') {
        $_SESSION['initiate_download_individual'] = $archivos_para_procesar_nombres[0]; // Solo hay uno
    } elseif ($tipo_descarga == 'masiva') {
        $_SESSION['initiate_download_bulk'] = [
            'filter_month_from' => $filter_month_from_str ?? '', // Pasa los filtros originales
            'filter_month_to' => $filter_month_to_str ?? '',
            // Opcional: podrías pasar 'archivos_a_descargar' => $archivos_para_procesar_nombres
            // si bulk_download.php los va a usar en lugar de volver a filtrar.
        ];
    }
    if (isset($conn) && $conn instanceof mysqli) $conn->close();
    header("Location: dashboard.php"); // Redirige a dashboard, y dashboard iniciará la descarga
    exit;
}

// Si llegamos aquí, hay archivos pendientes de firma ($archivos_pendientes_de_firma_nombres no está vacío)
// O la lista inicial de $archivos_para_procesar_nombres estaba vacía (ya manejado arriba con exit).
if (empty($archivos_pendientes_de_firma_nombres)) {
    // Este caso no debería ocurrir si la lógica anterior es correcta y $archivos_para_procesar_nombres no estaba vacío.
    // Pero por si acaso, para evitar mostrar una declaratoria vacía.
    $_SESSION['info_message'] = "No hay recibos pendientes de aceptación para los criterios seleccionados.";
    if (isset($conn) && $conn instanceof mysqli) $conn->close();
    header("Location: dashboard.php");
    exit;
}

$periodos_unicos_para_mostrar = [];
foreach ($archivos_pendientes_de_firma_nombres as $nombre_f) {
    $parts = explode('_', $nombre_f);
    if (count($parts) > 4) {
        $tipo_p = trim($parts[2] ?? 'Desconocido');
        $anio_p = (int)($parts[3] ?? 0);
        $num_p = (int)($parts[4] ?? 0);
        $recibos_a_firmar_desc[] = obtenerDescripcionPeriodo($tipo_p, $num_p, $anio_p);
    } else {
        $recibos_a_firmar_desc[] = "Recibo: " . htmlspecialchars($nombre_f);
    }
}
if (!empty($recibos_a_firmar_desc)) {
    $periodos_unicos_para_mostrar = array_unique($recibos_a_firmar_desc);
}

// Generar token CSRF para el formulario
$csrf_token = generate_csrf_token();

$page_title = "Confirmación de Descarga de Recibos";
require_once('includes/header.php'); 
?>
<main class="container"> {/* Sin main-container-flex-column para el layout de position:absolute de la barra */}

    <h2>Declaratoria de Aceptación de Recibos</h2>
    
    <div class="carta-declaratoria-container">
        <?php if (file_exists($ruta_logo_cliente_web) && is_readable($ruta_logo_cliente_web)): ?>
            <img src="<?php echo htmlspecialchars($ruta_logo_cliente_web); ?>" alt="Logo <?php echo htmlspecialchars($nombre_empresa_cliente); ?>" style="max-height: 70px; margin-bottom: 15px; display:block; margin-left:auto; margin-right:auto;">
        <?php endif; ?>
        <h3 style="margin-top: 0; text-align:left;"><?php echo htmlspecialchars($nombre_empresa_cliente); ?></h3>
        <p><strong>A QUIEN CORRESPONDA:</strong></p>
        <p>Por medio de la presente, se hace constar que el/la trabajador(a) <strong>C. <?php echo htmlspecialchars($nombre_empleado); ?></strong>, 
            con ID de empleado <strong><?php echo htmlspecialchars($id_empleado_nomina_original); ?></strong>, 
            acepta y reconoce que la empresa <strong><?php echo htmlspecialchars($nombre_empresa_cliente); ?></strong> 
            le hará entrega en este acto, en formato digital a través de la plataforma Nom-Online, 
            del documento oficial denominado "Recibo de Nómina" correspondiente al siguiente periodo (o periodos):</p>
        
        <pre class="periodos-display-box">
<?php if (!empty($periodos_unicos_para_mostrar)): ?>
        <div class="lista-periodos-columnas">
            <ul>
                <?php foreach ($periodos_unicos_para_mostrar as $periodo_desc): ?>
                    <li><?php echo htmlspecialchars($periodo_desc); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
<?php else: ?>
            <p style="text-align:center;">No hay recibos específicos para esta aceptación.</p>
<?php endif; ?>
        </pre>
        <p>El/la trabajador(a) manifiesta su conformidad y aceptación con la entrega de dicho(s) documento(s).</p>
        <div style="margin-top: 30px; text-align: center;">
            <p style="font-size: 1.1em; margin-bottom: 5px;"><strong>C.<?php echo htmlspecialchars($nombre_empleado); ?></strong></p>
            <p style="font-size: 0.9em; color: #555;">Acepto la entrega de los documentos que se descargarán.</p>
        </div>
    </div>

    <div class="declaratoria-actions-bar">
        <form action="procesar_aceptacion_y_descarga.php" method="POST" style="margin: 0; padding: 0;">
            <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">

            <input type="hidden" name="tipo_descarga" value="<?php echo htmlspecialchars($tipo_descarga); ?>">
            <input type="hidden" name="archivos_a_firmar_json" value="<?php echo htmlspecialchars(json_encode($archivos_pendientes_de_firma_nombres)); ?>">
            
            <?php
            // Pasar los parámetros necesarios para la descarga final
            if ($tipo_descarga == 'individual' && isset($nombre_archivo_original_para_form)) {
                echo '<input type="hidden" name="param_descarga_filename" value="' . htmlspecialchars($nombre_archivo_original_para_form) . '">';
            } elseif ($tipo_descarga == 'masiva') {
                if (isset($filter_month_from_str) && $filter_month_from_str !== '') {
                     echo '<input type="hidden" name="param_descarga_filter_month_from" value="' . htmlspecialchars($filter_month_from_str) . '">';
                }
                if (isset($filter_month_to_str) && $filter_month_to_str !== '') {
                    echo '<input type="hidden" name="param_descarga_filter_month_to" value="' . htmlspecialchars($filter_month_to_str) . '">';
                }
            }
            ?>
            
            <button type="submit" class="button" style="font-size: 1.1em; padding: 10px 20px;">Aceptar y Descargar</button>
            <a href="dashboard.php" class="button button-outline" style="margin-left: 10px; font-size: 1.1em; padding: 10px 20px;">Cancelar</a>
        </form>
    </div>
</main>
<?php 
require_once('includes/footer.php'); 
if (isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}
?>