<?php
// login.php
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_httponly' => true,
        'cookie_secure' => isset($_SERVER['HTTPS']),
        'cookie_samesite' => 'Lax'
    ]);
}

// Si ya está logueado y NO necesita cambiar contraseña, redirigir al index
if (isset($_SESSION['user_id']) && (!isset($_SESSION['must_change_password']) || $_SESSION['must_change_password'] === false)) {
    header("Location: index.php");
    exit;
}
// Si ya está logueado y SÍ necesita cambiar contraseña, pero intenta acceder a login.php, redirigirlo a change_initial_password.php
if (isset($_SESSION['user_id']) && isset($_SESSION['must_change_password']) && $_SESSION['must_change_password'] === true) {
    header("Location: change_initial_password.php");
    exit;
}

require_once('config/database.php'); // Conexión a BD
require_once('includes/functions.php'); // ¡NUEVO Y MUY IMPORTANTE! Para funciones CSRF

$error_message = '';
$success_message = ''; 

// Generar token CSRF para el formulario de login
$csrf_token = generate_csrf_token();

// Procesar login
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // 1. Validar el token CSRF primero
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        $error_message = "Error de validación de seguridad. Por favor, intente de nuevo recargando la página.";
        // Log del intento fallido de CSRF
        error_log("CSRF token validation failed for login attempt. Username: " . ($_POST['username'] ?? 'N/A') . " IP: " . $_SERVER['REMOTE_ADDR']);
    } else {
        // Token CSRF válido, continuar con el login
        $username = trim($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';

        if (!empty($username) && !empty($password)) {
            $sql = "SELECT id, password_hash, employee_id, is_admin, is_supervisor, full_name, force_password_change 
                    FROM user WHERE username = ?";
            $stmt = $conn->prepare($sql);
            
            if ($stmt) {
                $stmt->bind_param("s", $username);
                $stmt->execute();
                $result = $stmt->get_result();

                if ($result->num_rows === 1) {
                    $user = $result->fetch_assoc();
                    if (password_verify($password, $user['password_hash'])) {
                        session_regenerate_id(true); 
                        
                        $_SESSION['user_id'] = $user['id'];
                        $_SESSION['username'] = $username; 
                        $_SESSION['full_name'] = $user['full_name'];
                        $_SESSION['last_activity'] = time(); 

                        if (isset($user['force_password_change']) && (bool)$user['force_password_change'] === true) {
                            $_SESSION['must_change_password'] = true;
                            header("Location: change_initial_password.php");
                            exit;
                        } else {
                            $_SESSION['must_change_password'] = false; 
                            $_SESSION['employee_id'] = $user['employee_id'];
                            $_SESSION['is_admin'] = (bool)$user['is_admin'];
                            $_SESSION['is_supervisor'] = (bool)$user['is_supervisor'];
                            
                            header("Location: index.php"); 
                            exit;
                        }
                    }
                }
                $error_message = "Usuario o contraseña incorrectos.";
                $stmt->close();
            } else {
                error_log("Error al preparar login: " . $conn->error);
                $error_message = "Error del servidor. Inténtelo más tarde.";
            }
        } else {
            $error_message = "Por favor, ingresa usuario y contraseña.";
        }
    } // Fin de la validación CSRF y procesamiento del login
    if (isset($conn) && $conn instanceof mysqli) $conn->close();
}

// Mensajes GET (logout, errores de auth_check, etc.)
// (Esta lógica de mensajes GET se mantiene igual que la tenías)
if (isset($_GET['message']) && $_GET['message'] == 'logout_success') {
    $success_message = "Has cerrado sesión correctamente.";
}
if (isset($_GET['message']) && $_GET['message'] == 'password_changed') {
    $success_message = "Contraseña actualizada correctamente. Por favor, inicia sesión con tu nueva contraseña.";
}
if (empty($error_message) && isset($_GET['error'])) { // Solo mostrar error GET si no hay uno de POST
    switch ($_GET['error']) {
        case 'auth_required': $error_message = "Debes iniciar sesión para acceder a esa página."; break;
        case 'admin_required': $error_message = "Acceso restringido a administradores."; break;
        case 'session_expired': $error_message = "Tu sesión ha expirado por inactividad."; break;
        case 'password_change_required': $error_message = "Debes cambiar tu contraseña antes de continuar."; break;
    }
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Iniciar Sesión - Nom-Online</title>
    <style>@import url('https://fonts.googleapis.com/css2?family=Poppins:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap');</style>
    <link rel="stylesheet" href="public/css/estilos.css">
</head>
<body>
<div class="login-page-wrapper">
    <div class="info-column">
        <h1>Nom-Online</h1>
        <div class="icon-container">
            <svg xmlns="http://www.w3.org/2000/svg" width="80" height="80" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="feather feather-download-cloud"><path d="M18.948 11.112C18.511 7.67 15.563 5 12.004 5c-2.756 0-5.15 1.611-6.243 4.15-2.148.642-3.757 2.67-3.757 4.85 0 2.757 2.243 5 5 5h1v-2h-1c-1.654 0-3-1.346-3-3 0-1.404 1.199-2.757 2.673-3.016l.581-.102.192-.558C8.153 8.273 9.898 7 12.004 7c2.757 0 5 2.243 5 5v1h1c1.103 0 2 .897 2 2s-.897 2-2 2h-2v2h2c2.206 0 4-1.794 4-4a4.008 4.008 0 0 0-3.056-3.888z"></path><path d="M13.004 14v-4h-2v4h-3l4 5 4-5z"></path></svg>
        </div>
        <p class="tagline">Consulta y descarga tus recibos de nómina de forma segura.</p>
        <div class="company-logo-container">
            <img src="public/images/logo_corporativo.png" alt="Logo de la Empresa">
        </div>
        <div class="contact-info">
            <p>¿Problemas para ingresar?</p>
            <p>Contacta a soporte: <span>descargaturecibo@dae.com.mx</span></p>
            <p>Envía tu solicitud de soporte.</p>
        </div>
    </div>

    <div class="login-column">
        <div class="login-form-container">
            <h2>Iniciar Sesión</h2>

            <?php if ($error_message): ?>
                <p class="error"><?php echo htmlspecialchars($error_message); ?></p>
            <?php endif; ?>
            <?php if ($success_message): ?>
                <p class="success"><?php echo htmlspecialchars($success_message); ?></p>
            <?php endif; ?>

            <form method="post" action="login.php" class="login-form">
                <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
                
                <div class="form-group">
                    <label for="username">Usuario</label>
                    <input type="text" id="username" name="username" required autocomplete="username">
                </div>
                <div class="form-group">
                    <label for="password">Contraseña</label>
                    <input type="password" id="password" name="password" required autocomplete="current-password">
                </div>
                <div class="form-group">
                    <button type="submit">Entrar</button>
                </div>
            </form>

            <div style="text-align: center; margin-top: 15px;">
                <a href="forgot_password.php" style="font-size: 0.9em; color: #00695c;">¿Olvidaste tu contraseña?</a>
            </div>

            <div class="login-footer-attribution" style="width: 100%; text-align: center; margin-top: 30px; padding-bottom: 20px;">
                <p style="font-size: 0.85em; color: #777; margin: 0;">Corporativo Empresarial © <?php echo date('Y'); ?>. Todos los derechos reservados.</p>
            </div>
        </div>
    </div>
</div>
</body>
</html>