<?php
// index.php (Archivo Raíz - MODIFICADO)

// Iniciar la sesión si no está iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Primero, verificar si el usuario está logueado.
// Si no hay user_id en la sesión, se redirige a login.php.
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Si está logueado, actualizamos su última actividad para el timeout de sesión.
// Esta línea es importante y la añadí de mi sugerencia anterior.
// Si ya la tienes en un 'auth_check.php' que se incluye en todas las páginas,
// podría no ser estrictamente necesaria aquí, pero no hace daño.
if (isset($_SESSION['last_activity'])) { // Solo si ya existe (se crea en login)
    $_SESSION['last_activity'] = time();
}


// Ahora, decidimos a dónde redirigir basado en los roles almacenados en la sesión:
// La jerarquía de roles que usaremos es: Admin > Supervisor > Empleado.
// Un Admin tiene los mayores privilegios. Un Supervisor tiene más que un Empleado.

if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true) {
    // Si el usuario es Administrador, se redirige a la lista de usuarios del panel de admin.
    header("Location: admin/users_list.php"); // O tu página principal de admin
    exit;
} elseif (isset($_SESSION['is_supervisor']) && $_SESSION['is_supervisor'] === true) {
    // Si NO es Admin, PERO SÍ es Supervisor, se redirige al nuevo dashboard de supervisor.
    // Esta es la nueva condición que estamos añadiendo.
    // La carpeta 'supervisor' y el archivo 'dashboard.php' dentro de ella los crearemos en el siguiente paso.
    header("Location: supervisor/dashboard.php");
    exit;
} else {
    // Si no es ni Administrador ni Supervisor, entonces es un empleado regular.
    // Se redirige al dashboard de empleado normal.
    header("Location: dashboard.php");
    exit;
}

// El 'exit;' después de cada header("Location: ..."); es importante para asegurar
// que el script termine su ejecución inmediatamente después de la redirección.
// El que tenías al final del archivo original ya cubría esto, pero es bueno tenerlo
// después de cada 'header' por claridad y seguridad.
?>