<?php
// includes/supervisor_check.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// 1. Verificar si el usuario está logueado
if (!isset($_SESSION['user_id'])) {
    // Asumiendo que login.php está en la raíz del proyecto, y este archivo está en includes/
    header("Location: ../login.php?error=auth_required"); 
    exit;
}

// 2. Verificar si el usuario tiene el rol adecuado (Debe ser Supervisor O Administrador)
$is_supervisor = isset($_SESSION['is_supervisor']) && $_SESSION['is_supervisor'] === true;
$is_admin = isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true;

if (!$is_supervisor && !$is_admin) { 
    // Si NO es supervisor Y TAMPOCO es admin, no tiene permisos.
    // Redirigir al dashboard de empleado o a donde consideres apropiado.
    // Puedes añadir un mensaje de error a la sesión si quieres.
    // $_SESSION['error_message'] = "No tiene permisos para acceder a esta sección de supervisión.";
    header("Location: ../dashboard.php"); // Redirige al dashboard de empleado
    exit;
}

// 3. Lógica de Timeout de Sesión (como la tenías, es buena práctica)
$session_timeout = 1800; // 30 minutos (30 * 60 segundos)
if (isset($_SESSION['last_activity']) && (time() - $_SESSION['last_activity'] > $session_timeout)) {
    session_unset();
    session_destroy();
    header("Location: ../login.php?error=session_expired"); // Ajusta la ruta si es necesario
    exit;
}
$_SESSION['last_activity'] = time(); // Actualizar el último tiempo de actividad

// Si se llega hasta aquí, el usuario está autenticado y tiene el rol de supervisor o de administrador.
// La conexión a la BD (require_once(__DIR__ . '/../config/database.php');) 
// puedes mantenerla comentada aquí si no todas las páginas de supervisor la necesitan
// y la incluyes individualmente en las que sí.
?>