<?php
// includes/header.php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

$company_name = "Corporativo Empresarial"; // O el nombre que uses, ej: "Anfitriones A.P.R."
// Asegúrate que esta ruta absoluta al logo sea correcta desde la raíz de tu servidor web
$logo_path = "/public/images/corp.png"; // Si tu logo se llama 'logo_corporativo.png', usa esa.

$display_name_header = $_SESSION['full_name'] ?? $_SESSION['username'] ?? null;

// Para construir URLs de forma más segura y fácil de mantener, considera definir una constante URL_BASE
// en un archivo de configuración global, ej: define('URL_BASE', 'http://tu_dominio.com/nom-online/');
// Si no, las rutas absolutas desde la raíz web como "/admin/users_list.php" suelen funcionar bien.
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="stylesheet" href="/public/css/estilos.css"> <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/style.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/themes/material_blue.css">
    <script>
        window.addEventListener('pageshow', function(event) {
            if (event.persisted) {
                window.location.reload();
            }
        });
    </script>
    <title><?php echo isset($page_title) ? htmlspecialchars($page_title) : 'Nom-Online'; ?> - <?php echo htmlspecialchars($company_name); ?></title>
</head>
<body>
    <header class="main-header">
        <div class="logo">
            <a href="/index.php">
                <img src="<?php echo htmlspecialchars($logo_path); ?>" alt="Logo <?php echo htmlspecialchars($company_name); ?>">
            </a>
        </div>
        <div class="company-title">
            <?php echo htmlspecialchars($company_name); ?>
        </div>
        
        <?php if ($display_name_header): ?>
            <div class="user-welcome">
                <span class="welcome-message">Bienvenido, <?php echo htmlspecialchars($display_name_header); ?>!</span>
                
                <?php if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true): ?>
                    <a href="/admin/users_list.php">Admin Usuarios</a>
                    <a href="/supervisor/dashboard.php">Vista Supervisor</a> <?php elseif (isset($_SESSION['is_supervisor']) && $_SESSION['is_supervisor'] === true && (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] === false) ): ?>
                    <?php // Supervisor no-admin solo ve su enlace a su dashboard normal ?>
                    <a href="/supervisor/dashboard.php">Dashboard Supervisor</a>
                <?php endif; ?>
                
                <a href="/logout.php">Cerrar Sesión</a>
            </div>
        <?php endif; ?>
    </header>

    <?php // IMPORTANTE: La etiqueta <main class="container..."> ya NO se abre aquí.
          // Cada página individual (dashboard.php, supervisor/dashboard.php, etc.)
          // deberá abrir su propia etiqueta <main class="container..."> después de incluir este header,
          // y cerrarla antes de incluir el footer.php.
    ?>