<?php
// includes/functions.php

// --- INICIO: Inclusión de PHPMailer y Sesión ---
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

// Cargar archivos de PHPMailer (la ruta debe ser correcta)
require_once __DIR__ . '/PHPMailer/src/Exception.php';
require_once __DIR__ . '/PHPMailer/src/PHPMailer.php';
require_once __DIR__ . '/PHPMailer/src/SMTP.php';

if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
// --- FIN: Inclusión ---


// --- INICIO: FUNCIONES CSRF (Sin cambios) ---
function generate_csrf_token() {
    if (empty($_SESSION['csrf_token'])) {
        try {
            $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
        } catch (Exception $e) {
            $_SESSION['csrf_token'] = bin2hex(openssl_random_pseudo_bytes(32));
        }
    }
    return $_SESSION['csrf_token'];
}
function validate_csrf_token($token_from_form) {
    if (!isset($_SESSION['csrf_token']) || !isset($token_from_form)) { return false; }
    return hash_equals($_SESSION['csrf_token'], $token_from_form);
}
// --- FIN: FUNCIONES CSRF ---


// --- OTRAS FUNCIONES (sin cambios) ---
function obtenerNumeroMes($tipoPeriodo, $numeroPeriodo) {
    $tipoPeriodoLower = strtolower(trim($tipoPeriodo)); $numeroPeriodo = (int)$numeroPeriodo;
    if ($tipoPeriodoLower == 'quincenal') { if ($numeroPeriodo >= 1 && $numeroPeriodo <= 24) { return ceil($numeroPeriodo / 2); }
    } elseif ($tipoPeriodoLower == 'mensual') { if ($numeroPeriodo >= 1 && $numeroPeriodo <= 12) { return $numeroPeriodo; }
    } elseif (in_array($tipoPeriodoLower, ['semanal', 'periodo extraordinario', 'extraordinario'])) { return null; }
    return null; 
}
function obtenerDescripcionPeriodo($tipoPeriodo, $numeroPeriodo, $anio) {
    $tipoPeriodoLower = strtolower(trim($tipoPeriodo)); $numeroPeriodo = (int)$numeroPeriodo; $anio = (int)$anio;
    $descripcion = ""; $nombresMeses = ["", "Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
    if (in_array($tipoPeriodoLower, ['periodo extraordinario', 'extraordinario'])) { $descripcion = "Periodo Extraordinario " . $numeroPeriodo;
    } elseif ($tipoPeriodoLower == 'mensual') { if ($numeroPeriodo >= 1 && $numeroPeriodo <= 12) { $descripcion = $nombresMeses[$numeroPeriodo]; } else { $descripcion = "Mensual " . $numeroPeriodo; }
    } elseif ($tipoPeriodoLower == 'quincenal') {
        $mes = obtenerNumeroMes($tipoPeriodoLower, $numeroPeriodo); 
        if ($mes && $mes >= 1 && $mes <= 12) { $quincenaNum = ($numeroPeriodo % 2 == 0) ? "2da" : "1ra"; if ($numeroPeriodo == 23) $quincenaNum = "1ra"; if ($numeroPeriodo == 24) $quincenaNum = "2da"; $descripcion = $quincenaNum . " Quincena " . $nombresMeses[$mes];
        } else { $descripcion = "Quincena " . $numeroPeriodo; }
    } elseif ($tipoPeriodoLower == 'semanal') { $descripcion = "Semana " . $numeroPeriodo;
    } else { $descripcion = ucfirst(trim($tipoPeriodo)) . " " . $numeroPeriodo; }
    return $descripcion . " - " . $anio;
}
function compararPeriodosDesc($archivoA, $archivoB) {
    if ($archivoA['anio'] != $archivoB['anio']) { return $archivoB['anio'] <=> $archivoA['anio']; }
    $esExtraA = in_array(strtolower($archivoA['tipo_periodo']), ['periodo extraordinario', 'extraordinario']);
    $esExtraB = in_array(strtolower($archivoB['tipo_periodo']), ['periodo extraordinario', 'extraordinario']);
    if ($esExtraA && !$esExtraB) { return 1; } if (!$esExtraA && $esExtraB) { return -1;} if ($esExtraA && $esExtraB) { return (int)$archivoB['num_periodo'] <=> (int)$archivoA['num_periodo']; }
    $mesA = $archivoA['mes_numero'] ?? null; $mesB = $archivoB['mes_numero'] ?? null;
    if ($mesA !== null && $mesB !== null) { if ($mesA != $mesB) { return $mesB <=> $mesA; }} elseif ($mesA !== null) { return -1; } elseif ($mesB !== null) { return 1; }
    $numA = (int)$archivoA['num_periodo']; $numB = (int)$archivoB['num_periodo'];
    if ($numA != $numB) { return $numB <=> $numA; } return strcmp($archivoA['nombre'], $archivoB['nombre']); 
}
function generarPasswordSeguro($longitud = 12) {
    if ($longitud < 8) { $longitud = 8; } $sets = ['abcdefghijklmnopqrstuvwxyz', 'ABCDEFGHIJKLMNOPQRSTUVWXYZ', '0123456789', '!@#$%^&*()-_=+<>?'];
    $passwordCaracteres = []; $todosLosCaracteres = '';
    foreach ($sets as $set) { if (empty($set)) continue; $passwordCaracteres[] = $set[random_int(0, strlen($set) - 1)]; $todosLosCaracteres .= $set; }
    if (empty($todosLosCaracteres)) { return 'ErrorPassGen1'; }
    $longitudRestante = $longitud - count($passwordCaracteres); 
    for ($i = 0; $i < $longitudRestante; $i++) { if (strlen($todosLosCaracteres) > 0) { $passwordCaracteres[] = $todosLosCaracteres[random_int(0, strlen($todosLosCaracteres) - 1)]; } else { $passwordCaracteres[] = 'X'; } }
    shuffle($passwordCaracteres); return implode('', $passwordCaracteres);
}


/**
 * NUEVA FUNCIÓN DE ENVÍO DE CORREO USANDO PHPMAILER
 * Envía un correo electrónico con formato HTML con los datos de acceso al usuario.
 */
function enviarCorreoAccesos($email_destinatario, $nombre_completo, $username, $password_en_texto_plano, $url_sitio, $nombre_plataforma = "Nom-Online") {
    if (empty($email_destinatario)) {
        error_log("EnviarAccesos: Intento de envío sin email_destinatario para usuario " . $username);
        return false;
    }

    $mail = new PHPMailer(true); // El 'true' activa las excepciones

    try {
        // Configuración del servidor SMTP
        // $mail->SMTPDebug = SMTP::DEBUG_SERVER; // <<--- CAMBIO: Se usan las constantes directamente gracias al 'use' de arriba
        $mail->isSMTP();
        $mail->Host       = SMTP_HOST;
        $mail->SMTPAuth   = true;
        $mail->Username   = SMTP_USER;
        $mail->Password   = SMTP_PASS;
        $mail->SMTPSecure = (SMTP_SECURE === 'tls') ? PHPMailer::ENCRYPTION_STARTTLS : PHPMailer::ENCRYPTION_SMTPS; // <<--- CAMBIO
        $mail->Port       = SMTP_PORT;

        $mail->CharSet = 'UTF-8';

        // Remitente
        $mail->setFrom(MAIL_FROM_ADDRESS, MAIL_FROM_NAME);

        // Destinatarios
        $emails = explode(';', $email_destinatario);
        foreach ($emails as $email) {
            $email_limpio = trim($email);
            if (filter_var($email_limpio, FILTER_VALIDATE_EMAIL)) {
                $mail->addAddress($email_limpio, $nombre_completo);
            }
        }
        
        if (count($mail->getAllRecipientAddresses()) == 0) {
            error_log("EnviarAccesos: Ninguna dirección de correo válida encontrada en '{$email_destinatario}' para usuario {$username}.");
            return false;
        }

        // Cuerpo del correo
        $url_base_sitio = preg_replace('/\/[^\/]*$/', '', $url_sitio);
        $logo_url = $url_base_sitio . "/public/images/logo_corporativo.png";
        $asunto = "Sus Datos de Acceso a la Plataforma " . $nombre_plataforma;
        
        $mail->isHTML(true);
        $mail->Subject = $asunto;
        $mail->Body    = <<<HTML
        <!DOCTYPE html><html lang="es"><head><meta charset="UTF-8"><title>{$asunto}</title><style>body{font-family:Arial,sans-serif;background-color:#f4f4f4;color:#333;margin:0;padding:0}.container{max-width:600px;margin:20px auto;background-color:#ffffff;border:1px solid #dddddd;border-radius:5px}.header{background-color:#f8f8f8;padding:20px;text-align:center;border-bottom:1px solid #dddddd}.header img{max-width:200px}.content{padding:30px;line-height:1.6}.content strong{color:#004d40}.credentials{background-color:#f0f2f5;padding:15px;border-radius:4px;margin:20px 0}.footer{padding:20px;text-align:center;font-size:.9em;color:#777}a.button{display:inline-block;padding:10px 20px;margin-top:20px;background-color:#00695c;color:#ffffff;text-decoration:none;border-radius:5px}</style></head><body><div class="container"><div class="header"><img src="{$logo_url}" alt="Logo de {$nombre_plataforma}"></div><div class="content"><p>Estimado/a <strong>{$nombre_completo}</strong>,</p><p>Se han generado/actualizado sus credenciales de acceso para la plataforma <strong>{$nombre_plataforma}</strong>.</p><div class="credentials"><p><strong>Usuario:</strong> {$username}</p><p><strong>Contraseña Temporal:</strong> {$password_en_texto_plano}</p></div><p>Por su seguridad, se le pedirá cambiar esta contraseña después de su primer inicio de sesión.</p><p style="text-align:center"><a href="{$url_sitio}" class="button">Ir a la Plataforma para Iniciar Sesión</a></p></div><div class="footer"><p>&copy; {$nombre_plataforma} - Por favor, no responda a este correo electrónico.</p></div></div></body></html>
HTML;
        $mail->AltBody = "Estimado/a {$nombre_completo},\n\nSe han generado/actualizado sus credenciales de acceso para la plataforma {$nombre_plataforma}.\n\nURL de Acceso: {$url_sitio}\nUsuario: {$username}\nContraseña Temporal: {$password_en_texto_plano}\n\nPor su seguridad, se le pedirá cambiar esta contraseña después de su primer inicio de sesión.";

        $mail->send();
        error_log("EnviarAccesos (PHPMailer): Correo de acceso enviado a " . $email_destinatario . " para usuario " . $username);
        return true;
    } catch (Exception $e) {
        // En la instancia de PHPMailer, Exception ya está en el scope correcto por el 'use' de arriba
        error_log("EnviarAccesos (PHPMailer): El correo no pudo ser enviado. Error: {$mail->ErrorInfo} para usuario {$username}");
        return false;
    }
}