<?php
// includes/footer.php
// No necesita más PHP aquí si el contenido es estático.
?>
<?php // Cierre del <main> que se abre en header.php ?>

    <footer style="text-align: center; margin-top: 2rem; padding: 1rem 0; border-top: 1px solid var(--muted-border-color);"> <?php // Añadido estilo para centrar y un poco de margen/padding/borde opcional ?>
        <p style="margin-bottom: 0;"> <?php // Quitar margen inferior del párrafo si el footer ya tiene padding ?>
            Corporativo Empresarial © 2025. Todos los derechos reservados.
        </p>
        <?php // Puedes añadir más elementos aquí si es necesario ?>
    </footer>
<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script src="https://cdn.jsdelivr.net/npm/flatpickr/dist/plugins/monthSelect/index.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Inicializar Flatpickr en los inputs con la clase 'month-picker'
    flatpickr(".month-picker", {
        plugins: [
            new monthSelectPlugin({
                shorthand: true,    // Muestra el mes como "Ene", "Feb", etc. (formato corto)
                dateFormat: "Y-m",  // Formato que se envía al servidor (YYYY-MM)
                altFormat: "F Y",   // Formato que ve el usuario (ej: "Enero 2025")
                theme: "light"      // Tema visual (otros: "dark", "material_blue", etc.)
            })
        ],
        // Para que el campo se limpie si el usuario borra el texto manualmente
        allowInput: true, 
        // Opcional: Para traducir los meses (si no toma el idioma del navegador)
        // locale: { 
        //     firstDayOfWeek: 1, // Lunes
        //     months: {
        //         shorthand: ['Ene', 'Feb', 'Mar', 'Abr', 'May', 'Jun', 'Jul', 'Ago', 'Sep', 'Oct', 'Nov', 'Dic'],
        //         longhand: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio', 'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre']
        //     }
        // }
    });

    // Tu script existente para mostrar/ocultar filtros
    function toggleFilters() {
        var filterContainer = document.getElementById("filter-container");
        if (filterContainer.style.display === "none" || filterContainer.style.display === "") {
            filterContainer.style.display = "block";
        } else {
            filterContainer.style.display = "none";
        }
    }
    // Hacer que el botón sea accesible (si no lo has hecho global)
    const toggleButton = document.querySelector('.filter-toggle button');
    if (toggleButton) {
        toggleButton.onclick = toggleFilters;
    }


    const urlParams = new URLSearchParams(window.location.search);
    let monthFromVal = urlParams.get('filter_month_from');
    let monthToVal = urlParams.get('filter_month_to');

    if ((monthFromVal && monthFromVal !== "") || (monthToVal && monthToVal !== "")) {
         var filterContainer = document.getElementById("filter-container");
         if (filterContainer) {
            filterContainer.style.display = "block";
         }
    }
});
</script>
</body>
</html>