<?php
// historial_aceptaciones.php

// 1. Verificación de sesión y dependencias
require_once('includes/auth_check.php'); // Asegura que el usuario esté logueado
require_once('config/database.php');    // Conexión a la BD
require_once('includes/functions.php');   // Para obtenerDescripcionPeriodo y otras

// 2. Definir título de la página
$page_title = 'Mi Historial de Aceptaciones';

// 3. Lógica para obtener el historial del usuario actual
$historial_aceptaciones = [];
$user_id_actual = $_SESSION['user_id'] ?? null;

if ($user_id_actual && $conn) {
    $sql = "SELECT nombre_archivo_recibo, fecha_descarga, ruta_carta_aceptacion 
            FROM descargas_recibos 
            WHERE id_usuario = ? AND ruta_carta_aceptacion IS NOT NULL AND ruta_carta_aceptacion <> ''
            ORDER BY fecha_descarga DESC";
    
    $stmt = $conn->prepare($sql);
    if ($stmt) {
        $stmt->bind_param("i", $user_id_actual);
        $stmt->execute();
        $result = $stmt->get_result();
        while ($row = $result->fetch_assoc()) {
            // Obtener descripción del periodo para cada recibo
            $parts = explode('_', $row['nombre_archivo_recibo']);
            $descripcion_periodo = "No disponible";
            if (count($parts) > 4) {
                $tipo_p = trim($parts[2] ?? 'Desconocido');
                $anio_p = (int)($parts[3] ?? 0);
                $num_p = (int)($parts[4] ?? 0);
                $descripcion_periodo = obtenerDescripcionPeriodo($tipo_p, $num_p, $anio_p);
            }

            $historial_aceptaciones[] = [
                'nombre_recibo' => $row['nombre_archivo_recibo'],
                'periodo' => $descripcion_periodo,
                'fecha_aceptacion' => date('d/m/Y H:i:s', strtotime($row['fecha_descarga'])), // Formatear fecha
                'ruta_carta' => $row['ruta_carta_aceptacion']
            ];
        }
        $stmt->close();
    } else {
        error_log("HISTORIAL_ACEPTACIONES: Error preparando consulta: " . $conn->error);
        // Podrías mostrar un mensaje de error si la consulta falla
    }
}

// Incluir Cabecera HTML
require_once('includes/header.php');
?>
<main class="container">

    <h2><?php echo htmlspecialchars($page_title); ?></h2>

    <p><a href="dashboard.php" class="button button-outline">&laquo; Volver al Dashboard</a></p>

    <?php if (empty($historial_aceptaciones)): ?>
        <p style="margin-top: 20px;">Aún no has aceptado ningún recibo.</p>
    <?php else: ?>
        <div class="table-scroll-container" style="margin-top: 20px;">
            <table class="file-table">
                <thead>
                    <tr>
                        <th>Recibo (Nombre de Archivo)</th>
                        <th>Periodo</th>
                        <th>Fecha de Aceptación</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($historial_aceptaciones as $item): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($item['nombre_recibo']); ?></td>
                        <td><?php echo htmlspecialchars($item['periodo']); ?></td>
                        <td><?php echo htmlspecialchars($item['fecha_aceptacion']); ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php endif; ?>

</main>
<?php
require_once('includes/footer.php');
if (isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}
?>