<?php
// forgot_password.php
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_httponly' => true,
        'cookie_secure' => isset($_SERVER['HTTPS']),
        'cookie_samesite' => 'Lax'
    ]);
}

require_once('config/database.php'); 
require_once('includes/functions.php'); 

$page_title = 'Restablecer Contraseña';
$feedback_message = '';
$message_type = 'info';

$url_base_sitio = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://" . $_SERVER['HTTP_HOST'];
$nombre_plataforma_correo = "Nom-Online"; 

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        $feedback_message = "Error de validación de seguridad. Por favor, intente de nuevo.";
        $message_type = 'error';
    } else {
        $username_input = trim($_POST['username'] ?? '');
        $email_input = trim($_POST['email'] ?? '');

        if (empty($username_input) || empty($email_input)) {
            $feedback_message = "Por favor, ingrese su nombre de usuario y correo electrónico.";
            $message_type = 'error';
        } elseif (!filter_var($email_input, FILTER_VALIDATE_EMAIL)) {
            $feedback_message = "Por favor, ingrese una dirección de correo electrónico válida.";
            $message_type = 'error';
        } else {
            if ($conn) {
                // --- DEBUG: Log que estamos buscando ---
                error_log("FORGOT_PASSWORD_DEBUG: Buscando usuario con username: '{$username_input}'");

                $stmt_user = $conn->prepare("SELECT id, full_name, email FROM user WHERE username = ?");
                if ($stmt_user) {
                    $stmt_user->bind_param("s", $username_input);
                    $stmt_user->execute();
                    $result_user = $stmt_user->get_result();
                    $user_found_for_reset = null;

                    if ($user_data_row = $result_user->fetch_assoc()) {
                        // --- DEBUG: Log que el usuario fue encontrado ---
                        error_log("FORGOT_PASSWORD_DEBUG: Usuario encontrado. Verificando email. Email en BD: '" . ($user_data_row['email'] ?? 'NINGUNO') . "'. Email ingresado: '{$email_input}'.");
                        
                        $emails_en_bd = explode(';', $user_data_row['email'] ?? '');
                        $email_coincide = false;
                        foreach($emails_en_bd as $user_email_single){
                            if(strtolower(trim($user_email_single)) === strtolower($email_input)){ // Comparación sin importar mayúsculas/minúsculas
                                $email_coincide = true;
                                $user_found_for_reset = $user_data_row; 
                                break; 
                            }
                        }

                        if (!$email_coincide) {
                            // --- DEBUG: Log de email no coincidente ---
                            error_log("FORGOT_PASSWORD_DEBUG: Email NO coincide para el usuario '{$username_input}'.");
                        }

                    } else {
                        // --- DEBUG: Log de usuario no encontrado ---
                        error_log("FORGOT_PASSWORD_DEBUG: Ningún usuario encontrado con el username '{$username_input}'.");
                    }
                    
                    if ($user_found_for_reset) { // Si se encontró usuario y el email coincidió
                        $user_id = $user_found_for_reset['id'];
                        $full_name_user = $user_found_for_reset['full_name'];
                        
                        $plain_reset_token = bin2hex(random_bytes(32));
                        $hashed_reset_token = password_hash($plain_reset_token, PASSWORD_DEFAULT);
                        $reset_token_expires = date('Y-m-d H:i:s', time() + 3600); 

                        $stmt_update_token = $conn->prepare("UPDATE user SET password_reset_token = ?, password_reset_expires = ? WHERE id = ?");
                        if ($stmt_update_token) {
                            $stmt_update_token->bind_param("ssi", $hashed_reset_token, $reset_token_expires, $user_id);
                            if ($stmt_update_token->execute()) {
                                $link_reseteo = $url_base_sitio . "/reset_password.php?token=" . $plain_reset_token;
                                
                                // ¡¡¡AQUÍ ESTÁ EL LOG IMPORTANTE!!!
                                error_log("FORGOT_PASSWORD: Enlace de reseteo generado para {$username_input}: " . $link_reseteo);

                                // Lógica de envío de correo... (se mantiene igual)
                                $asunto_correo = "Restablecimiento de contraseña para " . $nombre_plataforma_correo;
                                $cuerpo_correo = "Estimado/a " . htmlspecialchars($full_name_user) . ",\n\nHemos recibido una solicitud para restablecer la contraseña de su cuenta (" . htmlspecialchars($username_input) . ").\n\nPara continuar, haga clic en el siguiente enlace:\n" . $link_reseteo . "\n\nEste enlace expirará en 1 hora.\n\nSaludos,\nEl equipo de " . $nombre_plataforma_correo;
                                $remitente_email = "no-reply@" . ($_SERVER['SERVER_NAME'] ?? 'tusitio.com');
                                $headers = "From: " . $nombre_plataforma_correo . " <" . $remitente_email . ">\r\nContent-Type: text/plain; charset=UTF-8";
                                mail($email_input, $asunto_correo, $cuerpo_correo, $headers);
                            } else {
                                 error_log("FORGOT_PASSWORD_DEBUG: Error al actualizar token de reseteo: " . $stmt_update_token->error);
                                 $_SESSION['temp_error_message'] = "Error del servidor (DBUpdate).";
                            }
                            $stmt_update_token->close();
                        } else {
                             error_log("FORGOT_PASSWORD_DEBUG: Error preparando update de token: " . $conn->error);
                             $_SESSION['temp_error_message'] = "Error del servidor (DBPrep).";
                        }
                    }
                    $stmt_user->close();
                    
                    if (!isset($_SESSION['temp_error_message'])){
                         $_SESSION['temp_success_message'] = "Si los datos proporcionados son correctos, se ha enviado un enlace a su correo electrónico.";
                    }

                    if(isset($conn) && $conn instanceof mysqli) $conn->close();
                    
                    if (isset($_SESSION['temp_error_message'])) {
                        $_SESSION['error_message_login_redirect'] = $_SESSION['temp_error_message']; unset($_SESSION['temp_error_message']);
                    }
                    if (isset($_SESSION['temp_success_message'])) {
                        $_SESSION['success_message_login_redirect'] = $_SESSION['temp_success_message']; unset($_SESSION['temp_success_message']);
                    }

                    header("Location: login.php?message=password_reset_link_sent_attempted");
                    exit;

                } else { 
                    error_log("FORGOT_PASSWORD_DEBUG: Error preparando consulta de usuario: " . $conn->error);
                    $feedback_message = "Error del servidor. Por favor, inténtelo más tarde."; $message_type = 'error';
                }
            } else { 
                 $feedback_message = "Error de conexión a la base de datos."; $message_type = 'error';
            }
        }
    } 
} 

$csrf_token = generate_csrf_token();
require_once('includes/header.php'); 
?>
<main class="container" style="max-width: 600px;">
    <h2><?php echo htmlspecialchars($page_title); ?></h2>
    
    <?php if (!empty($feedback_message)): // Solo mostrar errores si la página no redirigió ?>
        <p class="error"><?php echo htmlspecialchars($feedback_message); ?></p>
    <?php endif; ?>

    <p>Ingresa tu nombre de usuario y tu dirección de correo electrónico registrada. Si coinciden con una cuenta, te enviaremos un enlace para restablecer tu contraseña.</p>

    <form action="forgot_password.php" method="POST">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
        <div class="form-group">
            <label for="username">Nombre de Usuario:</label>
            <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($_POST['username'] ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <label for="email">Correo Electrónico Registrado:</label>
            <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
        </div>
        <div class="form-group">
            <button type="submit" class="button">Enviar Enlace de Restablecimiento</button>
        </div>
    </form>
    <p style="margin-top: 20px;"><a href="login.php" class="button button-outline">&laquo; Volver a Iniciar Sesión</a></p>
</main>
<?php
require_once('includes/footer.php');
if (isset($conn) && $conn instanceof mysqli && $_SERVER["REQUEST_METHOD"] !== "POST") {
    $conn->close();
}
?>