<?php
// dashboard.php

// 1. Verificación de sesión PRIMERO que nada
require_once('includes/auth_check.php');
require_once('includes/functions.php'); // Ya incluye las funciones actualizadas

// 2. Redirecciones si es admin o supervisor
if (isset($_SESSION['is_admin']) && $_SESSION['is_admin'] === true) {
    header("Location: admin/users_list.php"); 
    exit;
}
if (isset($_SESSION['is_supervisor']) && $_SESSION['is_supervisor'] === true && (!isset($_SESSION['is_admin']) || $_SESSION['is_admin'] === false)) {
    header("Location: supervisor/dashboard.php"); 
    exit;
}

// 3. Definir título de la página
$page_title = 'Dashboard de Recibos';

// --- INICIO: Lógica PHP ---

// Mensajes de sesión
$success_message_from_process = $_SESSION['success_message'] ?? null;
unset($_SESSION['success_message']); 

$info_message_from_process = $_SESSION['info_message'] ?? null;
unset($_SESSION['info_message']);

$error_message_from_process = $_SESSION['error_message'] ?? null;
unset($_SESSION['error_message']);


$bulk_download_error = $_SESSION['bulk_download_error'] ?? null;
$bulk_download_info = $_SESSION['bulk_download_info'] ?? null;
unset($_SESSION['bulk_download_error']);
unset($_SESSION['bulk_download_info']);

// Variables de sesión para iniciar descargas
$initiate_download_individual_file = $_SESSION['initiate_download_individual'] ?? null;
$initiate_download_bulk_params_json = isset($_SESSION['initiate_download_bulk']) ? json_encode($_SESSION['initiate_download_bulk']) : null;
unset($_SESSION['initiate_download_individual']);
unset($_SESSION['initiate_download_bulk']);


require_once('config/database.php'); 
$archivos_descargados_map = []; 

if ($conn && isset($_SESSION['user_id'])) {
    $id_usuario_actual_para_descargas = $_SESSION['user_id'];
    $sql_descargados = "SELECT nombre_archivo_recibo FROM descargas_recibos WHERE id_usuario = ? AND ruta_carta_aceptacion IS NOT NULL"; 
    $stmt_descargados = $conn->prepare($sql_descargados);
    if ($stmt_descargados) {
        $stmt_descargados->bind_param("i", $id_usuario_actual_para_descargas);
        $stmt_descargados->execute();
        $result_descargados = $stmt_descargados->get_result();
        while ($row_desc = $result_descargados->fetch_assoc()) {
            $archivos_descargados_map[$row_desc['nombre_archivo_recibo']] = true;
        }
        $stmt_descargados->close();
    } else { error_log("DASHBOARD: Error al preparar consulta para obtener descargas: " . $conn->error); }
}

// Función de comparación (ya la tienes en functions.php, solo asegúrate que esté disponible)
// if (!function_exists('compararPeriodosDesc')) { ... } // Podrías tener esta verificación si quieres

// Variables de empleado y filtros
$employee_id_session = $_SESSION['employee_id'] ?? null; 

$user_files_data = [];
$error_files = '';
$recibos_dir = __DIR__ . '/recibos_nomina'; 

// Leer parámetros de filtro GET para el formulario y la lógica PHP
$filter_month_from_str_get = filter_input(INPUT_GET, 'filter_month_from', FILTER_SANITIZE_SPECIAL_CHARS);
$filter_month_to_str_get = filter_input(INPUT_GET, 'filter_month_to', FILTER_SANITIZE_SPECIAL_CHARS);
$filters_active = !empty($filter_month_from_str_get) || !empty($filter_month_to_str_get);

if (!$employee_id_session) { 
    $error_files = "No se pudo identificar tu ID de empleado en la sesión.";
} elseif (!is_dir($recibos_dir) || !is_readable($recibos_dir)) {
    $error_files = "Error: La carpeta de recibos no existe o no se puede leer.";
    error_log("DASHBOARD: Error de acceso a la carpeta de recibos: " . $recibos_dir);
} else {
    
    // Parsear los valores de filtro para la lógica PHP
    $start_year_month_filter_php = null;
    if ($filter_month_from_str_get && preg_match('/^(\d{4})-(\d{2})$/', $filter_month_from_str_get, $m_from)) { // CORRECCIÓN AQUÍ
        $start_year_month_filter_php = (int)$m_from[1] * 100 + (int)$m_from[2];
    }
    $end_year_month_filter_php = null;
    if ($filter_month_to_str_get && preg_match('/^(\d{4})-(\d{2})$/', $filter_month_to_str_get, $m_to)) { // CORRECCIÓN AQUÍ
        $end_year_month_filter_php = (int)$m_to[1] * 100 + (int)$m_to[2];
    }

    $files = glob($recibos_dir . "/*.{zip,rar,ZIP,RAR}", GLOB_BRACE);

    if ($files === false) {
        $error_files = "Error al buscar archivos de recibos.";
    } elseif (!empty($files)) {
        foreach ($files as $filePath) {
            $filename = basename($filePath);
            $parts = explode('_', $filename);
            $file_emp_id_from_name_str = null;

            if (count($parts) > 5 && isset($parts[5])) { 
                 $id_part_raw = $parts[5];
                 $file_emp_id_from_name_str = trim(pathinfo($id_part_raw, PATHINFO_FILENAME));
                 if (!is_numeric($file_emp_id_from_name_str)) { 
                     if (preg_match('/^(\d+)/', $id_part_raw, $id_matches)) {
                        $file_emp_id_from_name_str = $id_matches[1];
                     } else {
                        $file_emp_id_from_name_str = null; 
                     }
                 }
            }
            
            if ($file_emp_id_from_name_str !== null && (int)$file_emp_id_from_name_str == (int)$employee_id_session) {
                $tipoPeriodo = trim($parts[2] ?? 'Desconocido');
                $anio_file = (int)($parts[3] ?? 0);
                $numeroPeriodo_file = (int)($parts[4] ?? 0);
                $mes_archivo = obtenerNumeroMes($tipoPeriodo, $numeroPeriodo_file); 
                
                $pasarFiltro = true;
                if ($filters_active) { 
                    if ($mes_archivo === null) { 
                        $pasarFiltro = false; 
                    } else { 
                        $file_year_month = $anio_file * 100 + $mes_archivo;
                        if ($start_year_month_filter_php !== null && $file_year_month < $start_year_month_filter_php) {
                            $pasarFiltro = false;
                        }
                        if ($pasarFiltro && $end_year_month_filter_php !== null && $file_year_month > $end_year_month_filter_php) {
                            $pasarFiltro = false;
                        }
                    }
                }
                
                if ($pasarFiltro) {
                    $descripcionPeriodo = obtenerDescripcionPeriodo($tipoPeriodo, $numeroPeriodo_file, $anio_file);
                    $user_files_data[] = [
                        'nombre' => $filename,
                        'periodo' => $descripcionPeriodo,
                        'anio' => $anio_file,
                        'num_periodo' => $numeroPeriodo_file,
                        'tipo_periodo' => $tipoPeriodo,
                        'mes_numero' => $mes_archivo 
                    ];
                }
            }
        }
        if (!empty($user_files_data)) {
            if (function_exists('compararPeriodosDesc')) {
                 usort($user_files_data, 'compararPeriodosDesc');
            } else {
                error_log("DASHBOARD: La función compararPeriodosDesc no está definida.");
            }
        }
    }
}
// --- FIN: Lógica PHP ---

require_once('includes/header.php');
?>
<main class="container main-container-flex-column">

    <?php if ($success_message_from_process): ?>
        <p class="success" style="margin-bottom:15px;"><?php echo htmlspecialchars($success_message_from_process); ?></p>
    <?php endif; ?>
    <?php if ($info_message_from_process): ?>
        <p class="success" style="margin-bottom:15px; background-color: #e6f7ff; border-color: #b3e0ff; color: #005f99;"><?php echo htmlspecialchars($info_message_from_process); ?></p>
    <?php endif; ?>
    <?php if ($error_message_from_process): ?>
        <p class="error" style="margin-bottom:15px;"><?php echo htmlspecialchars($error_message_from_process); ?></p>
    <?php endif; ?>

    <?php if ($bulk_download_error): ?>
        <p class="error" style="margin-bottom:15px;"><?php echo htmlspecialchars($bulk_download_error); ?></p>
    <?php endif; ?>
    <?php if ($bulk_download_info): ?>
        <p class="success" style="margin-bottom:15px;"><?php echo htmlspecialchars($bulk_download_info); ?></p>
    <?php endif; ?>
    <?php if ($error_files): ?>
        <p class="error" style="margin-bottom:15px;"><?php echo htmlspecialchars($error_files); ?></p>
    <?php endif; ?>

    <div style="margin-bottom: 20px;">
        <a href="historial_aceptaciones.php" class="button">Ver Mi Historial de Aceptaciones</a>
    </div>
    <div class="filter-toggle">
        <button type="button" onclick="toggleFilters()" class="button button-outline" style="margin-bottom: 15px;">Mostrar/Ocultar Filtros</button>
    </div>
    <div id="filter-container" class="filter-container" style="<?php echo $filters_active ? 'display: block;' : 'display: none;'; ?>">
        <form method="get" action="dashboard.php" class="filter-form">
            <fieldset>
                <legend>Filtrar Recibos</legend>
                <div class="grid">
                    <div>
                        <label for="filter_month_from">Mes Desde:</label>
                        <input type="text" class="month-picker" id="filter_month_from" name="filter_month_from"
                               value="<?php echo htmlspecialchars($filter_month_from_str_get ?? ''); ?>"
                               placeholder="Selecciona mes inicio">
                    </div>
                    <div>
                        <label for="filter_month_to">Mes Hasta:</label>
                         <input type="text" class="month-picker" id="filter_month_to" name="filter_month_to"
                               value="<?php echo htmlspecialchars($filter_month_to_str_get ?? ''); ?>"
                               placeholder="Selecciona mes Fin">
                    </div>
                    <div style="align-self: flex-end;">
                        <button type="submit" class="button">Filtrar</button>
                        <a href="dashboard.php" class="button button-outline" style="margin-left: 5px;">Limpiar</a>
                    </div>
                </div>
            </fieldset>
        </form>
    </div>

    <?php if (!empty($user_files_data) && $filters_active): ?>
    <div class="bulk-download-section" style="margin-top: 20px; margin-bottom: 20px; text-align: right;">
        <form method="get" action="mostrar_declaratoria.php">
            <input type="hidden" name="descarga_masiva" value="1">
            <input type="hidden" name="filter_month_from" value="<?php echo htmlspecialchars($filter_month_from_str_get ?? ''); ?>">
            <input type="hidden" name="filter_month_to" value="<?php echo htmlspecialchars($filter_month_to_str_get ?? ''); ?>">
            <button type="submit" name="accion_descargar_filtrados" class="button">Descargar Recibos Filtrados</button>
        </form>
    </div>
    <?php elseif ($filters_active && empty($user_files_data) && empty($error_files)): ?>
    <p style="margin-top: 20px;">No hay archivos que coincidan con los filtros actuales.</p>
    <?php endif; ?>

    <h2 style="margin-top: 30px;">Tus Recibos de Nómina</h2>
    <div class="table-scroll-container">
        <?php if (empty($user_files_data) && empty($error_files)): ?>
            <p style="margin-top: 20px;">No tienes archivos disponibles<?php echo $filters_active ? ' que coincidan con los filtros aplicados' : ''; ?>.</p>
        <?php elseif (!empty($user_files_data)): ?>
            <table class="file-table">
                <thead>
                    <tr>
                        <th>Nombre de Archivo</th>
                        <th>Periodo</th>
                        <th>Estado</th>
                        <th>Acción</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($user_files_data as $file_data): ?>
                    <tr>
                        <td><?php echo htmlspecialchars($file_data['nombre']); ?></td>
                        <td><?php echo htmlspecialchars($file_data['periodo']); ?></td>
                        <td>
                            <?php
                            if (isset($archivos_descargados_map[$file_data['nombre']])) {
                                echo '<span class="status-descargado">✔ Aceptado</span>';
                            } else {
                                echo '<span class="status-pendiente">▫ Pendiente</span>';
                            }
                            ?>
                        </td>
                        <td>
                            <a href="mostrar_declaratoria.php?recibo_individual=<?php echo urlencode($file_data['nombre']); ?>" class="button button-small button-download">
                                <?php echo isset($archivos_descargados_map[$file_data['nombre']]) ? 'Descargar de Nuevo' : 'Aceptar y Descargar'; ?>
                            </a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</main>
<?php
require_once('includes/footer.php');
if (isset($conn) && $conn instanceof mysqli) { // Verificar si $conn es un objeto mysqli válido
    $conn->close();
}
?>

<script>
function toggleFilters() {
  var filterContainer = document.getElementById("filter-container");
  if (filterContainer.style.display === "none" || filterContainer.style.display === "") {
    filterContainer.style.display = "block";
  } else {
    filterContainer.style.display = "none";
  }
}

document.addEventListener('DOMContentLoaded', function() {
    const urlParams = new URLSearchParams(window.location.search);
    let monthFromVal = urlParams.get('filter_month_from');
    let monthToVal = urlParams.get('filter_month_to'); 

    if ((monthFromVal && monthFromVal !== "") || (monthToVal && monthToVal !== "")) {
        var filterContainer = document.getElementById("filter-container");
        if (filterContainer) {
            filterContainer.style.display = "block";
        }
    }

    flatpickr(".month-picker", {
        plugins: [
            new monthSelectPlugin({
                shorthand: true, 
                dateFormat: "Y-m",
                altFormat: "F Y", 
                theme: "material_blue"
            })
        ],
        altInput: true
    });

    const initiateDownloadIndividualFile = <?php echo json_encode($initiate_download_individual_file); ?>;
    const initiateDownloadBulkParams = <?php echo $initiate_download_bulk_params_json ?? 'null'; ?>;

    if (initiateDownloadIndividualFile) {
        // console.log('Dashboard: Iniciando descarga individual para:', initiateDownloadIndividualFile);
        window.location.href = 'download.php?filename=' + encodeURIComponent(initiateDownloadIndividualFile);
    } else if (initiateDownloadBulkParams) {
        // console.log('Dashboard: Iniciando descarga masiva con parámetros:', initiateDownloadBulkParams);
        let form = document.createElement('form');
        form.method = 'post';
        form.action = 'admin/bulk_download.php'; 

        for (const key in initiateDownloadBulkParams) {
            if (initiateDownloadBulkParams.hasOwnProperty(key) && 
                initiateDownloadBulkParams[key] !== null && 
                initiateDownloadBulkParams[key] !== '') {
                let hiddenField = document.createElement('input');
                hiddenField.type = 'hidden';
                hiddenField.name = key;
                hiddenField.value = initiateDownloadBulkParams[key];
                form.appendChild(hiddenField);
            }
        }
        
        let downloadFilteredField = document.createElement('input');
        downloadFilteredField.type = 'hidden';
        downloadFilteredField.name = 'download_filtered'; 
        downloadFilteredField.value = '1';
        form.appendChild(downloadFilteredField);

        document.body.appendChild(form);
        form.submit();
        document.body.removeChild(form);
    }
});
</script>