<?php
// admin/user_save.php

require_once('../includes/admin_check.php');
require_once('../config/database.php'); 
require_once('../includes/functions.php'); 

$_SESSION['error_message'] = null;
$_SESSION['success_message'] = null;

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        $_SESSION['error_message'] = "Error de validación de seguridad (CSRF). La acción no se realizó.";
        header("Location: users_list.php");
        exit;
    }

    $user_id = $_POST['id'] ?? null; 
    $full_name = trim($_POST['full_name'] ?? '');
    $username = trim($_POST['username'] ?? '');
    $employee_id = trim($_POST['employee_id'] ?? '');
    $email_input = trim($_POST['email'] ?? ''); 
    $password_input = $_POST['password'] ?? '';
    $is_admin = isset($_POST['is_admin']) ? 1 : 0;
    $is_supervisor = isset($_POST['is_supervisor']) ? 1 : 0;

    $password_para_mostrar_admin = null; // Para mostrar la contraseña generada/establecida
    
    if (empty($username) || empty($employee_id) || empty($full_name)) {
        $_SESSION['form_error_message'] = "Nombre completo, Username y ID de Empleado son obligatorios.";
        $redirect_url = $user_id ? "user_form.php?id=" . $user_id : "user_form.php";
        header("Location: " . $redirect_url);
        exit;
    }

    $email_a_guardar = null;
    if (!empty($email_input)) {
        $emails_array = explode(';', $email_input);
        $emails_validos_para_guardar = [];
        foreach ($emails_array as $e) {
            $e_limpio = trim($e);
            if (filter_var($e_limpio, FILTER_VALIDATE_EMAIL)) {
                $emails_validos_para_guardar[] = $e_limpio;
            } elseif (!empty($e_limpio)) {
                $_SESSION['form_error_message'] = "El correo '".htmlspecialchars($e_limpio)."' no es válido. Si son varios, sepárelos con punto y coma (;).";
                $redirect_url = $user_id ? "user_form.php?id=" . $user_id : "user_form.php";
                header("Location: " . $redirect_url);
                exit;
            }
        }
        if (!empty($emails_validos_para_guardar)) {
            $email_a_guardar = implode(';', $emails_validos_para_guardar);
        }
    }

    $hashed_password_to_save = null;
    $set_force_password_change = 0; 
    // initial_access_sent se establece a 0 por defecto en la BD para nuevos usuarios
    // y no se toca al editar (el envío de accesos lo manejará).
    $stmt = null;
    $sql = ''; 

    if (!$user_id) { // --- CREAR NUEVO USUARIO ---
        if (empty($password_input)) {
            $password_para_mostrar_admin = generarPasswordSeguro(12); 
            $hashed_password_to_save = password_hash($password_para_mostrar_admin, PASSWORD_DEFAULT);
        } else {
            $password_para_mostrar_admin = $password_input; 
            $hashed_password_to_save = password_hash($password_input, PASSWORD_DEFAULT);
        }
        $set_force_password_change = 1; // Siempre forzar cambio para nuevos usuarios
        // initial_access_sent será 0 (default de BD)
        
        if (empty($hashed_password_to_save)) {
             $_SESSION['form_error_message'] = "Error crítico al procesar la contraseña.";
             header("Location: user_form.php");
             exit;
        }
        
        $sql = "INSERT INTO user (username, employee_id, password_hash, is_admin, is_supervisor, full_name, email, force_password_change, initial_access_sent) VALUES (?, ?, ?, ?, ?, ?, ?, ?, 0)"; // initial_access_sent = 0
        $stmt = $conn->prepare($sql);
        if ($stmt) {
            $stmt->bind_param("sssiissi", $username, $employee_id, $hashed_password_to_save, $is_admin, $is_supervisor, $full_name, $email_a_guardar, $set_force_password_change);
        } else { /* ... manejo de error ... */ }

    } else { // --- EDITAR USUARIO EXISTENTE ---
        if (!empty($password_input)) {
            $hashed_password_to_save = password_hash($password_input, PASSWORD_DEFAULT);
            $set_force_password_change = 1; 
            // No se modifica initial_access_sent al editar contraseña
            $sql = "UPDATE user SET username = ?, employee_id = ?, password_hash = ?, is_admin = ?, is_supervisor = ?, full_name = ?, email = ?, force_password_change = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("sssiissii", $username, $employee_id, $hashed_password_to_save, $is_admin, $is_supervisor, $full_name, $email_a_guardar, $set_force_password_change, $user_id);
            } else { /* ... manejo de error ... */ }
        } else {
            // Actualizar sin cambiar contraseña (no se toca force_password_change ni initial_access_sent)
            $sql = "UPDATE user SET username = ?, employee_id = ?, is_admin = ?, is_supervisor = ?, full_name = ?, email = ? WHERE id = ?";
            $stmt = $conn->prepare($sql);
            if ($stmt) {
                $stmt->bind_param("ssiissi", $username, $employee_id, $is_admin, $is_supervisor, $full_name, $email_a_guardar, $user_id);
            } else { /* ... manejo de error ... */ }
        }
         // Llenar los bloques de manejo de error para $stmt no creado (copiar de tu código anterior o de mi versión anterior)
        if (!$stmt) {
            $_SESSION['error_message'] = "Error al preparar la consulta de actualización: " . $conn->error;
            error_log("USER_SAVE (Update Prepare Error): " . $conn->error);
            header("Location: users_list.php");
            exit;
        }
    }

    if (isset($stmt)) {
        if ($stmt->execute()) {
            $accion = $user_id ? "actualizado" : "creado";
            $success_msg = "Usuario {$accion} correctamente.";
            
            if (!$user_id && $password_para_mostrar_admin) { 
                $success_msg .= " Contraseña establecida: <strong>" . htmlspecialchars($password_para_mostrar_admin) . "</strong>";
                $success_msg .= " (Comuníquela al usuario. Deberá cambiarla en su primer login. Use el botón 'Enviar Accesos Iniciales' de la lista para notificarle por correo).";
            } elseif ($user_id && !empty($password_input)){ 
                 $success_msg .= " La contraseña ha sido actualizada. El usuario deberá cambiarla en su próximo inicio de sesión.";
            }
            $_SESSION['success_message'] = $success_msg;
        } else { /* ... manejo de error de ejecución ... */ 
            if ($conn->errno == 1062) { $_SESSION['error_message'] = "Error: El Username o el ID de Empleado ya existen."; } 
            else { $_SESSION['error_message'] = "Error al guardar el usuario: " . $stmt->error; }
            error_log("USER_SAVE (Execute Error): " . $stmt->error . " SQL: " . ($sql ?? 'No SQL'));
        }
        $stmt->close();
    }
    
    if (isset($conn) && $conn instanceof mysqli) $conn->close();
    header("Location: users_list.php");
    exit;
} else {
    $_SESSION['error_message'] = "Acceso no válido.";
    header("Location: users_list.php");
    exit;
}
?>