<?php
// admin/user_form.php

require_once('../includes/admin_check.php');
require_once('../config/database.php'); 
require_once('../includes/functions.php'); // Para CSRF

$user_id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);
$username = '';
$employee_id = '';
$full_name = ''; 
$email = ''; 
$is_admin = 0;
$is_supervisor = 0;
$form_title = 'Añadir Nuevo Usuario';
$submit_button_text = 'Crear Usuario'; // El envío de accesos será un paso manual posterior
$password_placeholder = 'Dejar vacío para generar una contraseña segura';
// $password_required = false; // Se manejará en user_save.php si es nuevo y está vacío

if ($user_id) {
    $form_title = 'Editar Usuario';
    $submit_button_text = 'Actualizar Usuario';
    $password_placeholder = '(Dejar vacío para no cambiar contraseña)';
    
    $stmt = $conn->prepare("SELECT username, employee_id, is_admin, is_supervisor, full_name, email FROM user WHERE id = ?");
    if ($stmt) {
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($user_data = $result->fetch_assoc()) {
            $username = $user_data['username'];
            $employee_id = $user_data['employee_id'];
            $is_admin = $user_data['is_admin'];
            $is_supervisor = $user_data['is_supervisor'];
            $full_name = $user_data['full_name'] ?? '';
            $email = $user_data['email'] ?? '';
        } else {
            $_SESSION['error_message'] = "Error: Usuario con ID $user_id no encontrado.";
            header("Location: users_list.php");
            exit;
        }
        $stmt->close();
    } else {
        $_SESSION['error_message'] = "Error al preparar la consulta para buscar usuario: " . $conn->error;
        error_log("Error en prepare() user_form.php: " . $conn->error);
        header("Location: users_list.php");
        exit;
    }
}

$csrf_token = generate_csrf_token();
$page_title = $form_title; 
require_once('../includes/header.php');
?>
<main class="container">

    <h2><?php echo htmlspecialchars($form_title); ?></h2>
    <p><a href="users_list.php" class="button button-outline">&laquo; Volver a la Lista de Usuarios</a></p>

    <?php if (isset($_SESSION['form_error_message'])): ?>
        <p class="error"><?php echo htmlspecialchars($_SESSION['form_error_message']); unset($_SESSION['form_error_message']); ?></p>
    <?php endif; ?>

    <form action="user_save.php" method="post">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>">
        <?php if ($user_id): ?>
            <input type="hidden" name="id" value="<?php echo htmlspecialchars($user_id); ?>">
        <?php endif; ?>

        <div class="form-group">
            <label for="full_name">Nombre Completo:</label>
            <input type="text" id="full_name" name="full_name" value="<?php echo htmlspecialchars($full_name); ?>" required>
        </div>

        <div class="form-group">
            <label for="username">Username (para iniciar sesión):</label>
            <input type="text" id="username" name="username" value="<?php echo htmlspecialchars($username); ?>" required>
        </div>

        <div class="form-group">
            <label for="employee_id">ID Empleado (Nómina):</label>
            <input type="text" id="employee_id" name="employee_id" value="<?php echo htmlspecialchars($employee_id); ?>" required>
        </div>
        
        <div class="form-group">
            <label for="email">Correo(s) Electrónico(s):</label>
            <input type="text" id="email" name="email" value="<?php echo htmlspecialchars($email); ?>" placeholder="ejemplo@correo.com; otro@correo.com">
            <small>Si son varios, sepárelos con punto y coma (;). Necesario para el envío manual de accesos.</small>
        </div>

        <div class="form-group">
            <label for="password">Contraseña:</label>
            <input type="password" id="password" name="password" placeholder="<?php echo htmlspecialchars($password_placeholder); ?>">
             <?php if (!$user_id): // Solo para nuevos usuarios ?>
                <small>Si se deja vacío, se generará una contraseña segura. Los accesos se enviarán manualmente.</small>
            <?php else: ?>
                <small>Dejar vacío para no cambiar la contraseña actual. Si la cambia, el usuario deberá establecer una nueva al iniciar sesión.</small>
            <?php endif; ?>
        </div>

        <fieldset style="margin-bottom: 1.5rem; padding: 1rem; border: 1px solid #eee; border-radius: 4px;">
            <legend>Roles de Usuario</legend>
            <div class="form-group" style="margin-bottom: 0.5rem;">
                <input type="checkbox" id="is_admin" name="is_admin" value="1" <?php echo ($is_admin == 1) ? 'checked' : ''; ?> style="width: auto; vertical-align: middle; margin-right: 5px;">
                <label for="is_admin" style="display: inline; font-weight: normal;">¿Es Administrador?</label>
            </div>
            <div class="form-group">
                <input type="checkbox" id="is_supervisor" name="is_supervisor" value="1" <?php echo ($is_supervisor == 1) ? 'checked' : ''; ?> style="width: auto; vertical-align: middle; margin-right: 5px;">
                <label for="is_supervisor" style="display: inline; font-weight: normal;">¿Es Supervisor?</label>
            </div>
        </fieldset>

        <div class="form-group">
            <button type="submit" class="button"><?php echo $submit_button_text; ?></button>
        </div>
    </form>

</main>
<?php
require_once('../includes/footer.php');
if (isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}
?>