<?php
// admin/bulk_upload.php

require_once('../includes/admin_check.php');
$page_title = 'Admin - Carga Masiva Usuarios';

require_once('../config/database.php'); 
require_once('../includes/functions.php'); 

// Lógica para Descargar Resumen CSV
if (isset($_GET['action']) && $_GET['action'] === 'download_summary' && isset($_SESSION['bulk_upload_summary_data'])) {
    // ... (Esta lógica de descarga se mantiene igual que en la versión anterior que te di)
    $summary_data = $_SESSION['bulk_upload_summary_data'];
    unset($_SESSION['bulk_upload_summary_data']); 
    if (!empty($summary_data)) {
        header('Content-Type: text/csv; charset=utf-8');
        header('Content-Disposition: attachment; filename="resumen_carga_masiva_' . date('Ymd_His') . '.csv"');
        $output = fopen('php://output', 'w');
        fputcsv($output, ['Username', 'Nombre Completo', 'ID Empleado', 'Email(s)', 'Contraseña Generada', 'Estado Proceso']);
        foreach ($summary_data as $user_detail) {
            fputcsv($output, [
                $user_detail['username'], $user_detail['full_name'], $user_detail['employee_id'],
                $user_detail['email'], $user_detail['generated_password'] ?? 'N/A (Existente/Actualizado)',
                $user_detail['process_status']
            ]);
        }
        fclose($output); exit;
    } else {
        $_SESSION['bulk_upload_error_message_display'] = "No hay datos de resumen para descargar.";
        header("Location: bulk_upload.php"); exit;
    }
}

// Leer mensajes de sesión
$upload_message_display = $_SESSION['bulk_upload_message_display'] ?? null;
$error_message_display = $_SESSION['bulk_upload_error_message_display'] ?? null;
$info_message_display = $_SESSION['bulk_upload_info_message_display'] ?? null;
$users_processed_details_display = $_SESSION['bulk_upload_summary_display'] ?? [];
$errors_details_display = $_SESSION['bulk_upload_errors_details_display'] ?? [];
$success_count_display = $_SESSION['bulk_upload_success_count_display'] ?? 0; // Creados
$updated_count_display = $_SESSION['bulk_upload_updated_count_display'] ?? 0; // Actualizados
$skipped_count_display = $_SESSION['bulk_upload_skipped_count_display'] ?? 0; // Omitidos
$error_count_display = $_SESSION['bulk_upload_error_count_display'] ?? 0;   // Errores de fila

unset(
    $_SESSION['bulk_upload_message_display'], $_SESSION['bulk_upload_error_message_display'],
    $_SESSION['bulk_upload_info_message_display'], $_SESSION['bulk_upload_summary_display'],
    $_SESSION['bulk_upload_errors_details_display'], $_SESSION['bulk_upload_success_count_display'],
    $_SESSION['bulk_upload_updated_count_display'], $_SESSION['bulk_upload_skipped_count_display'],
    $_SESSION['bulk_upload_error_count_display']
);

if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_FILES["user_csv"])) {
    $upload_message = ''; $error_message = ''; $info_message = '';
    $success_count = 0; $updated_count = 0; $skipped_count = 0; $error_count = 0;
    $users_processed_details = []; $errors_details = []; 

    if (!isset($_POST['csrf_token']) || !validate_csrf_token($_POST['csrf_token'])) {
        $_SESSION['bulk_upload_error_message_display'] = "Error de validación de seguridad (CSRF token).";
        header("Location: bulk_upload.php"); exit;
    }
    
    $update_existing_users = isset($_POST['update_existing']) ? true : false;

    $file = $_FILES["user_csv"];
    // ... (Validaciones de archivo: error, tipo, tamaño - sin cambios)
    if ($file["error"] !== UPLOAD_ERR_OK) { /* ... error_message ... */ }
    elseif (!in_array(strtolower($file["type"]), ["text/csv", "application/vnd.ms-excel", "application/csv", "text/plain"])) { /* ... error_message ... */ }
    elseif ($file["size"] > 5000000) { /* ... error_message ... */ }
    else { // Archivo parece OK, procesar
        $tmp_name = $file["tmp_name"];
        $row_number = 1; $header_validated = false;
        $expected_header = ['codigo', 'nombre_completo', 'username', 'email']; 
        $header_map = [];                                                              

        if (($handle = fopen($tmp_name, "r")) !== FALSE) {
            setlocale(LC_ALL, 'es_ES.UTF-8', 'C.UTF-8', 'en_US.UTF-8', 'UTF-8');
            mb_internal_encoding('UTF-8');

            $conn->begin_transaction();
            try {
                while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
                    if ($row_number === 1) { 
                        // ... (Lógica de validación y mapeo de cabecera - SIN CAMBIOS) ...
                        $temp_header_csv = $data;
                        if (isset($temp_header_csv[0]) && strpos($temp_header_csv[0], "\xEF\xBB\xBF") === 0) { $temp_header_csv[0] = substr($temp_header_csv[0], 3); }
                        $csv_header_processed = array_map('strtolower', array_map('trim', $temp_header_csv));
                        $expected_header_lower = array_map('strtolower', $expected_header);
                        $missing_cols = [];
                        foreach($expected_header_lower as $expected_col) { if (!in_array($expected_col, $csv_header_processed)) $missing_cols[] = $expected_col; }
                        if (!empty($missing_cols)) throw new Exception("Cabecera del CSV inválida. Faltan: '" . implode("', '", $missing_cols) . "'. Esperadas: '" . implode(', ', $expected_header) . "'. Encontrada: '".implode(', ', $data)."'.");
                        foreach ($expected_header_lower as $col_name_expected) { $header_map[$col_name_expected] = array_search($col_name_expected, $csv_header_processed); }
                        $header_validated = true; $row_number++; continue;
                    }
                    if (!$header_validated) throw new Exception("Cabecera no validada.");
                    
                    $codigo = trim($data[$header_map['codigo']] ?? '');
                    $nombre_completo = trim($data[$header_map['nombre_completo']] ?? '');
                    $username = trim($data[$header_map['username']] ?? '');
                    $email_csv = trim($data[$header_map['email']] ?? '');

                    if (empty($codigo) || empty($nombre_completo) || empty($username)) {
                        $errors_details[] = "Fila {$row_number}: Faltan datos (código, nombre, username). Se omite.";
                        $error_count++; $row_number++; continue;
                    }
                    
                    $email_a_guardar = null;
                    if (!empty($email_csv)) { /* ... (lógica de validación de email - SIN CAMBIOS) ... */ 
                        $emails_array = explode(';', $email_csv); $emails_validos_para_guardar = [];
                        foreach ($emails_array as $e_single) {
                            $e_limpio = trim($e_single);
                            if (filter_var($e_limpio, FILTER_VALIDATE_EMAIL)) $emails_validos_para_guardar[] = $e_limpio;
                            elseif(!empty($e_limpio)) $errors_details[] = "Fila {$row_number}: Email inválido omitido '".htmlspecialchars($e_limpio)."' para ".htmlspecialchars($username).".";
                        }
                        if (!empty($emails_validos_para_guardar)) $email_a_guardar = implode(';', $emails_validos_para_guardar);
                    }

                    $existing_user_id = null;
                    $stmt_check = $conn->prepare("SELECT id FROM user WHERE username = ? OR employee_id = ?"); // Usar OR para más flexibilidad
                    if(!$stmt_check) throw new Exception("Error preparando verificación de usuario: ".$conn->error);
                    $stmt_check->bind_param("ss", $username, $codigo);
                    $stmt_check->execute();
                    $result_check = $stmt_check->get_result();
                    if($user_row = $result_check->fetch_assoc()) $existing_user_id = $user_row['id'];
                    $stmt_check->close();

                    $process_status_detail = '';
                    $generated_password_for_report = null;

                    if ($existing_user_id) { 
                        if ($update_existing_users) {
                            $sql_update = "UPDATE user SET full_name = ?, email = ? WHERE id = ?"; // Solo actualiza nombre y email
                            $stmt_update = $conn->prepare($sql_update);
                            if ($stmt_update) {
                                $stmt_update->bind_param("ssi", $nombre_completo, $email_a_guardar, $existing_user_id);
                                if ($stmt_update->execute()) {
                                    $updated_count++; $process_status_detail = 'Actualizado';
                                } else {
                                    $errors_details[] = "Fila {$row_number}: Error DB al actualizar ".htmlspecialchars($username).": " . $stmt_update->error;
                                    $error_count++; $process_status_detail = 'Error al actualizar';
                                }
                                $stmt_update->close();
                            } else { /* ... error preparando update ... */ }
                        } else {
                            $skipped_count++; $process_status_detail = 'Omitido (ya existe)';
                        }
                         $users_processed_details[] = [
                            'username' => $username, 'full_name' => $nombre_completo,
                            'employee_id' => $codigo, 'email' => $email_a_guardar ?? 'N/A',
                            'generated_password' => 'N/A (Usuario existente)',
                            'process_status' => $process_status_detail
                        ];
                    } else { // Nuevo usuario
                        $generated_password_plain = generarPasswordSeguro(12);
                        $hashed_password = password_hash($generated_password_plain, PASSWORD_DEFAULT);
                        $force_password_change = 1; 
                        $initial_access_sent = 0; // Nuevo campo
                        $is_admin_val = 0; // Admin crea usuarios estándar por defecto vía bulk
                        $is_supervisor_val = 0;

                        if ($hashed_password === false) { /* ... error hasheo ... */ }

                        $sql_insert = "INSERT INTO user (employee_id, full_name, username, password_hash, email, is_admin, is_supervisor, force_password_change, initial_access_sent) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
                        $stmt_insert = $conn->prepare($sql_insert);
                        if ($stmt_insert) {
                            // ssssi i i i  (string, string, string, string, string, int, int, int, int)
                            $stmt_insert->bind_param("sssssiiii", $codigo, $nombre_completo, $username, $hashed_password, $email_a_guardar, $is_admin_val, $is_supervisor_val, $force_password_change, $initial_access_sent);
                            if ($stmt_insert->execute()) {
                                $success_count++; $process_status_detail = 'Creado';
                                $generated_password_for_report = $generated_password_plain;
                            } else { /* ... error insert ... */ }
                            $stmt_insert->close();
                        } else { /* ... error preparando insert ... */ }
                        $users_processed_details[] = [
                            'username' => $username, 'full_name' => $nombre_completo,
                            'employee_id' => $codigo, 'email' => $email_a_guardar ?? 'N/A',
                            'generated_password' => $generated_password_for_report,
                            'process_status' => $process_status_detail
                        ];
                    }
                    $row_number++;
                } 
                fclose($handle);

                // Lógica de commit/rollback (similar a la anterior, ajustada para nuevos contadores)
                if ($error_count > 0 && ($success_count + $updated_count) == 0) { 
                    $conn->rollback(); $_SESSION['sv_bulk_upload_error_message_display'] = "Proceso con errores críticos. No se procesó ningún usuario."; // Cambiado a sv_
                } elseif ($error_count > 0) { 
                     $conn->commit();
                     $_SESSION['sv_bulk_upload_message_display'] = "Carga parcialmente completada. " // Cambiado a sv_
                        . ($success_count > 0 ? "{$success_count} creados. " : "")
                        . ($updated_count > 0 ? "{$updated_count} actualizados. " : "")
                        . "{$error_count} filas con error. "
                        . ($skipped_count > 0 ? "{$skipped_count} omitidos. " : "");
                } elseif (($success_count + $updated_count) > 0 || $skipped_count > 0) { 
                    $conn->commit();
                    $_SESSION['sv_bulk_upload_message_display'] = "¡Carga completada! " // Cambiado a sv_
                        . ($success_count > 0 ? "{$success_count} creados. " : "")
                        . ($updated_count > 0 ? "{$updated_count} actualizados. " : "")
                        . ($skipped_count > 0 ? "{$skipped_count} omitidos. " : "");
                     if ($success_count == 0 && $updated_count == 0 && $skipped_count > 0 && $error_count == 0) { 
                        $_SESSION['sv_bulk_upload_info_message_display'] = "Todos los usuarios del archivo ya existían y fueron omitidos."; // Cambiado a sv_
                        $_SESSION['sv_bulk_upload_message_display'] = null; 
                     }
                } else { 
                     $conn->rollback(); 
                     $_SESSION['sv_bulk_upload_info_message_display'] = "El archivo CSV no contenía datos procesables."; // Cambiado a sv_
                }
            } catch (Exception $e) { /* ... rollback y mensaje de error ... */ }
        } else { /* ... error abriendo archivo ... */ }
        
        $_SESSION['sv_bulk_upload_summary_display'] = $users_processed_details; // Cambiado a sv_
        $_SESSION['sv_bulk_upload_errors_details_display'] = $errors_details; // Cambiado a sv_
        $_SESSION['sv_bulk_upload_success_count_display'] = $success_count; // Cambiado a sv_
        $_SESSION['sv_bulk_upload_updated_count_display'] = $updated_count; // Cambiado a sv_
        $_SESSION['sv_bulk_upload_skipped_count_display'] = $skipped_count; // Cambiado a sv_
        $_SESSION['sv_bulk_upload_error_count_display'] = $error_count;   // Cambiado a sv_

        if (!empty($users_processed_details)) {
            $_SESSION['bulk_upload_summary_data'] = $users_processed_details; // Este es para el admin, mantener nombre original
        }
    } // Fin validaciones archivo y POST
    
    if (isset($conn) && $conn instanceof mysqli) $conn->close();
    header("Location: bulk_upload.php"); // Redirigir para mostrar mensajes vía GET
    exit;
} 
// ... (El resto del archivo HTML de bulk_upload.php para mostrar el formulario y los resultados
//      se mantiene igual que en la versión anterior que te di, solo asegúrate que use las 
//      variables de sesión con prefijo _display para mostrar los contadores y detalles)
//      Por ejemplo: $success_count_display, $updated_count_display, etc.
//      Y el formulario ahora incluye el checkbox:
//      <input type="checkbox" id="update_existing" name="update_existing" value="1"> Actualizar...
//      Lo añadiré al HTML que te devuelvo.

$csrf_token = generate_csrf_token(); 
require_once('../includes/header.php'); 
?>
<main class="container">
    <h2><?php echo htmlspecialchars($page_title); ?></h2>
    <p><a href="users_list.php" class="button button-outline">&laquo; Volver a la Lista de Usuarios</a></p>

    <?php if ($upload_message_display): ?>
        <p class="success" style="white-space: pre-wrap;"><?php echo htmlspecialchars($upload_message_display); ?></p>
    <?php endif; ?>
    <?php if ($error_message_display): ?>
        <p class="error"><?php echo htmlspecialchars($error_message_display); ?></p>
    <?php endif; ?>
    <?php if ($info_message_display): ?>
        <p style="padding: 10px; background-color: #e6f7ff; border: 1px solid #b3e0ff; color: #005f99; border-radius: 4px;"><?php echo htmlspecialchars($info_message_display); ?></p>
    <?php endif; ?>

    <?php if (!empty($users_processed_details_display)): ?>
        <div class="processed-users-summary" style="margin-top: 20px; margin-bottom:20px; border: 1px solid #ccc; padding: 15px; border-radius: 5px;">
            <h3>
                Resumen del Procesamiento: 
                <?php 
                $summary_parts = [];
                if ($success_count_display > 0) $summary_parts[] = "{$success_count_display} Creados";
                if ($updated_count_display > 0) $summary_parts[] = "{$updated_count_display} Actualizados";
                if ($skipped_count_display > 0) $summary_parts[] = "{$skipped_count_display} Omitidos";
                echo implode(', ', $summary_parts);
                if (empty($summary_parts) && $error_count_display == 0) echo "No se procesaron usuarios nuevos o para actualizar.";
                ?>
            </h3>
            <?php if ($success_count_display > 0): ?>
            <p><strong>IMPORTANTE:</strong> Para usuarios nuevos, anote las contraseñas generadas. Deberán cambiarla en su primer inicio de sesión. Use el botón "Enviar Accesos Iniciales" en la lista de usuarios para notificarles.</p>
            <?php endif; ?>
            
            <?php if(!empty($users_processed_details_display)) : ?>
            <div style="margin-bottom: 15px; text-align: right;">
                <a href="bulk_upload.php?action=download_summary" class="button button-secondary">Descargar Este Resumen como CSV</a>
            </div>
            <?php endif; ?>

            <div class="table-scroll-container" style="max-height: 300px;">
                <table class="file-table">
                    <thead>
                        <tr>
                            <th>Username</th>
                            <th>Nombre Completo</th>
                            <th>ID Empleado</th>
                            <th>Email(s)</th>
                            <th>Contraseña Generada (Nuevos)</th>
                            <th>Estado del Proceso</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($users_processed_details_display as $detail): ?>
                            <tr style="<?php 
                                if(stripos($detail['process_status'], 'Error') !== false) echo 'background-color: #ffebee; color: #c62828;'; 
                                elseif($detail['process_status'] === 'Actualizado') echo 'background-color: #e3f2fd; color: #1565c0;'; 
                                elseif($detail['process_status'] === 'Omitido (ya existe)') echo 'background-color: #fffde7; color: #f9a825;';
                                elseif($detail['process_status'] === 'Creado') echo 'background-color: #e8f5e9; color: #2e7d32;';
                                ?>">
                                <td><?php echo htmlspecialchars($detail['username']); ?></td>
                                <td><?php echo htmlspecialchars($detail['full_name']); ?></td>
                                <td><?php echo htmlspecialchars($detail['employee_id']); ?></td>
                                <td><?php echo htmlspecialchars($detail['email'] ?? 'N/A'); ?></td>
                                <td>
                                    <?php if (!empty($detail['generated_password'])): ?>
                                        <strong><?php echo htmlspecialchars($detail['generated_password']); ?></strong>
                                    <?php else: ?>
                                        N/A
                                    <?php endif; ?>
                                </td>
                                <td><?php echo htmlspecialchars($detail['process_status']); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    <?php endif; ?>
    
    <?php if (!empty($errors_details_display)): ?>
        <div class="error-details" style="border:1px solid #dc3545; padding: 10px; margin-bottom:15px; background-color:#f8d7da; border-radius:4px;">
            <h4>Detalles de Errores en Filas Específicas (<?php echo $error_count_display; ?>):</h4>
            <ul style="max-height: 200px; overflow-y: auto; list-style-position: inside; padding-left: 15px;">
                <?php foreach ($errors_details_display as $detail): ?>
                    <li><?php echo htmlspecialchars($detail); ?></li>
                <?php endforeach; ?>
            </ul>
        </div>
    <?php endif; ?>

    <form action="bulk_upload.php" method="post" enctype="multipart/form-data" style="margin-top: 20px;">
        <input type="hidden" name="csrf_token" value="<?php echo htmlspecialchars($csrf_token); ?>"> 
        <p>Selecciona un archivo CSV para subir. La primera línea debe ser la cabecera con los siguientes nombres de columna (el orden puede variar, pero deben estar todas):<br>
            <strong>codigo, nombre_completo, username, email</strong>
        </p>
        <p><small>La contraseña para cada usuario nuevo se generará automáticamente y se le pedirá cambiarla en su primer login. Para usuarios existentes, la contraseña no se modificará.</small></p>
        
        <div class="form-group">
            <label for="user_csv">Archivo CSV:</label>
            <input type="file" name="user_csv" id="user_csv" accept=".csv, text/csv, application/csv, application/vnd.ms-excel, text/plain" required>
        </div>

        <div class="form-group" style="margin-top: 10px; margin-bottom: 15px;">
            <input type="checkbox" id="update_existing" name="update_existing" value="1" style="width: auto; vertical-align: middle; margin-right: 5px;">
            <label for="update_existing" style="display: inline; font-weight: normal;">Actualizar información (Nombre, Email) de usuarios existentes si se encuentran en el CSV.</label>
            <small style="display:block; margin-top: 5px;">Si no se marca, los usuarios existentes en el CSV serán omitidos.</small>
        </div>
        
        <div class="form-group">
            <button type="submit" class="button">Subir y Procesar Usuarios</button> 
        </div>
    </form>
    <p style="margin-top: 20px;"><small>
        Nota: Si un 'username' o 'codigo' (ID Empleado) en una fila para un nuevo usuario ya existe y no se marca la opción de actualizar, esa fila será omitida.
    </small></p>
</main>
<?php
require_once('../includes/footer.php');
if (isset($conn) && $conn instanceof mysqli) {
    $conn->close();
}
?>